/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.domain.sync.framework.meta;

import com.alibaba.bizworks.ads.meta.lang.file.MdFile;
import com.alibaba.bizworks.ads.meta.lang.module.MdModule;
import com.alibaba.bizworks.ide.domain.sync.framework.config.ConfigManager;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.enterprise.EnterpriseAppYamlConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.enterprise.EnterpriseGlobalYamlConfig;
import com.alibaba.bizworks.ide.domain.sync.framework.config.model.enterprise.EnterpriseYamlConfigFile;
import com.alibaba.bizworks.ide.domain.sync.framework.config.msg.MsgPublisher;
import com.alibaba.bizworks.ide.domain.sync.framework.meta.MetadataCaches;
import com.alibaba.bizworks.ide.domain.sync.framework.meta.MetadataManager;
import com.alibaba.bizworks.ide.domain.sync.framework.meta.gateway.MetadataGateway;
import com.alibaba.bizworks.ide.domain.user.UserManager;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public abstract class MetadataManagerImpl
implements MetadataManager {
    protected final MetadataGateway metadataGateway;
    private final ConfigManager configManager;
    private final MsgPublisher msgPublisher;
    private final UserManager userManager;
    protected final MetadataCaches metadataCaches;

    public MetadataManagerImpl(MetadataGateway metadataGateway, ConfigManager configManager, MsgPublisher msgPublisher, UserManager userManager, MetadataCaches metadataCaches) {
        this.metadataGateway = metadataGateway;
        this.configManager = configManager;
        this.msgPublisher = msgPublisher;
        this.userManager = userManager;
        this.metadataCaches = metadataCaches;
    }

    @Override
    public <T extends MdFile> T findByQname(String qname, Class<T> tClass) {
        return this.metadataCaches.findByQname(qname, tClass);
    }

    @Override
    public void updateMetadataCache() {
        EnterpriseAppYamlConfig application;
        EnterpriseGlobalYamlConfig bizworks;
        Collection<MdModule> metaModules = this.getModulesFromConfig();
        EnterpriseYamlConfigFile enterpriseYamlConfigFile = this.configManager.getEnterpriseYamlConfigFile();
        String code = "";
        if (enterpriseYamlConfigFile != null && (bizworks = enterpriseYamlConfigFile.getBizworks()) != null && (application = bizworks.getApplication()) != null) {
            code = application.getCode();
        }
        if (CollectionUtils.isNotEmpty(metaModules)) {
            List<MdModule> newModules = this.metadataGateway.getAllMetadata(metaModules, code);
            this.metadataCaches.replaceAll(newModules);
            this.msgPublisher.metadataChanged(newModules);
        }
    }

    protected abstract Collection<MdModule> getModulesFromConfig();

    @Override
    public Collection<MdModule> getAllModuleAndMetadata() {
        return this.metadataCaches.getAllModulesAndMeta();
    }

    @Override
    public Collection<MdModule> getAllNeedsBuild(Long lastBuildId) {
        return this.metadataCaches.getAllModulesAndMeta();
    }

    @Override
    public void updateMetadata(MdFile metadata) {
        this.metadataGateway.saveMetadata(metadata);
        MdFile newOne = this.metadataGateway.fetchNewOne(metadata);
        if (newOne != null) {
            this.metadataCaches.replace(newOne);
        }
    }
}

