/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.plugin.utils.plugin;

import com.alibaba.bizworks.ide.plugin.utils.plugin.ZDisposableRunnable;
import com.alibaba.bizworks.ide.plugin.utils.plugin.ZDisposeGuard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/alibaba/bizworks/ide/plugin/utils/plugin/ZDisposableRunnableWrapper;", "Lcom/alibaba/bizworks/ide/plugin/utils/plugin/ZDisposableRunnable;", "task", "Ljava/lang/Runnable;", "(Ljava/lang/Runnable;)V", "disposeGuard", "Lcom/alibaba/bizworks/ide/plugin/utils/plugin/ZDisposeGuard;", "thread", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Thread;", "dispose", "", "run", "Companion", "plugin-common"})
public final class ZDisposableRunnableWrapper
implements ZDisposableRunnable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Runnable task;
    @NotNull
    private final AtomicReference<Thread> thread;
    @NotNull
    private final ZDisposeGuard disposeGuard;
    @NotNull
    private static final Logger log;

    public ZDisposableRunnableWrapper(@NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.task = task;
        this.thread = new AtomicReference();
        this.disposeGuard = new ZDisposeGuard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.disposeGuard.isActive()) {
                this.thread.set(Thread.currentThread());
                this.task.run();
            }
            this.thread.set(null);
        }
        catch (Throwable throwable) {
            this.thread.set(null);
            Disposer.dispose((Disposable)this);
            Object[] objectArray = new Object[]{this.task, " was done"};
            log.debug("Disposed after ", objectArray);
            throw throwable;
        }
        Disposer.dispose((Disposable)this);
        Object[] objectArray = new Object[]{this.task, " was done"};
        log.debug("Disposed after ", objectArray);
    }

    public void dispose() {
        Thread thread = this.thread.getAndSet(null);
        if (thread != null) {
            thread.interrupt();
        }
        Disposer.dispose((Disposable)this.disposeGuard);
    }

    static {
        Logger logger = Logger.getInstance(ZDisposableRunnableWrapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/alibaba/bizworks/ide/plugin/utils/plugin/ZDisposableRunnableWrapper$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "plugin-common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

