/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.plugin.utils.tempRef;

import com.alibaba.bizworks.ide.common.plugin.exception.PsiResolveException;
import com.alibaba.bizworks.ide.plugin.utils.psi.AnnotationUtilsKt;
import com.alibaba.bizworks.ide.plugin.utils.psi.Operator;
import com.alibaba.bizworks.ide.plugin.utils.psi.PsiConstEnumUtils;
import com.alibaba.bizworks.ide.plugin.utils.psi.PsiExtKt;
import com.alibaba.bizworks.ide.plugin.utils.tempRef.PsiExpressionResolver;
import com.intellij.lang.jvm.JvmNamedElement;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u0004\u0018\u00010\u00012\b\u0010\u0019\u001a\u0004\u0018\u00010&2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020(H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u0004\u0018\u00010\u00012\u0006\u0010-\u001a\u00020\u0001J\u0012\u0010.\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020/H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/alibaba/bizworks/ide/plugin/utils/tempRef/PsiExpressionResolver;", "", "()V", "log", "Lmu/KLogger;", "resolveArrayAccessExpression", "psiExpression", "Lcom/intellij/psi/PsiArrayAccessExpression;", "resolveBinaryExpression", "Lcom/intellij/psi/PsiBinaryExpression;", "resolveClassObjectAccessExpression", "Lcom/intellij/psi/PsiClassObjectAccessExpression;", "resolveEnumFields", "", "", "value", "Lcom/intellij/psi/PsiEnumConstant;", "resolveLambdaExpression", "Lcom/intellij/psi/PsiLambdaExpression;", "resolveLocalVariable", "psiVariable", "Lcom/intellij/psi/PsiLocalVariable;", "resolvePolyadicExpression", "Lcom/intellij/psi/PsiPolyadicExpression;", "resolvePsiAnnotation", "psiElement", "Lcom/intellij/psi/PsiAnnotation;", "resolvePsiExpression", "Lcom/intellij/psi/PsiExpression;", "nullIfUnResolved", "", "resolvePsiField", "psiField", "Lcom/intellij/psi/PsiField;", "resolvePsiType", "psiType", "Lcom/intellij/psi/PsiType;", "resolvePsiVal", "Lcom/intellij/psi/PsiElement;", "resolveReferenceExpression", "Lcom/intellij/psi/PsiReferenceExpression;", "resolveStaticField", "resolveUnaryExpression", "Lcom/intellij/psi/PsiUnaryExpression;", "resolveVal", "any", "resolveVariable", "Lcom/intellij/psi/PsiVariable;", "tryComputeConst", "plugin-common"})
@SourceDebugExtension(value={"SMAP\nPsiExpressionResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiExpressionResolver.kt\ncom/alibaba/bizworks/ide/plugin/utils/tempRef/PsiExpressionResolver\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n11335#2:225\n11670#2,3:226\n11335#2:229\n11670#2,3:230\n11335#2:234\n11670#2,3:235\n1#3:233\n2730#4,7:238\n*S KotlinDebug\n*F\n+ 1 PsiExpressionResolver.kt\ncom/alibaba/bizworks/ide/plugin/utils/tempRef/PsiExpressionResolver\n*L\n41#1:225\n41#1:226,3\n42#1:229\n42#1:230,3\n154#1:234\n154#1:235,3\n155#1:238,7\n*E\n"})
public final class PsiExpressionResolver {
    @NotNull
    public static final PsiExpressionResolver INSTANCE = new PsiExpressionResolver();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    private PsiExpressionResolver() {
    }

    @Nullable
    public final Object resolveVal(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return any instanceof PsiElement ? PsiExpressionResolver.resolvePsiVal$default(this, (PsiElement)any, false, 2, null) : any.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object resolvePsiVal(@Nullable PsiElement psiElement, boolean nullIfUnResolved) {
        Object object;
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof PsiAnnotation) {
            object = this.resolvePsiAnnotation((PsiAnnotation)psiElement);
        } else if (psiElement2 instanceof PsiExpression) {
            object = this.resolvePsiExpression((PsiExpression)psiElement, nullIfUnResolved);
        } else if (psiElement2 instanceof PsiLiteralValue) {
            object = ((PsiLiteralValue)psiElement).getValue();
        } else if (psiElement2 instanceof PsiLocalVariable) {
            object = this.resolveLocalVariable((PsiLocalVariable)psiElement);
        } else if (psiElement2 instanceof PsiEnumConstant) {
            object = this.resolveEnumFields((PsiEnumConstant)psiElement);
        } else if (psiElement2 instanceof PsiField) {
            object = this.resolvePsiField((PsiField)psiElement);
        } else if (psiElement2 instanceof PsiVariable) {
            object = this.resolveVariable((PsiVariable)psiElement);
        } else if (psiElement2 instanceof PsiKeyword) {
            object = ((PsiKeyword)psiElement).getText();
        } else if (psiElement2 instanceof PsiReferenceParameterList) {
            object = ((PsiReferenceParameterList)psiElement).getText();
        } else if (psiElement2 instanceof PsiWhiteSpace) {
            object = ((PsiWhiteSpace)psiElement).getText();
        } else if (psiElement2 instanceof PsiJavaCodeReferenceElement) {
            object = ((PsiJavaCodeReferenceElement)psiElement).getText();
        } else if (psiElement2 instanceof PsiExpressionList) {
            void $this$mapTo$iv$iv;
            PsiExpression[] psiExpressionArray = ((PsiExpressionList)psiElement).getExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)psiExpressionArray, (String)"getExpressions(...)");
            Object[] $this$map$iv = psiExpressionArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiExpression psiExpression = (PsiExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(INSTANCE.resolvePsiExpression((PsiExpression)it, nullIfUnResolved));
            }
            object = (List)destination$iv$iv;
        } else if (psiElement2 instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = ((PsiArrayInitializerMemberValue)psiElement).getInitializers();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationMemberValueArray, (String)"getInitializers(...)");
            Object[] $this$map$iv = psiAnnotationMemberValueArray;
            boolean $i$f$map = false;
            Object[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PsiAnnotationMemberValue it = (PsiAnnotationMemberValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PsiExpressionResolver.resolvePsiVal$default(INSTANCE, (PsiElement)it, false, 2, null));
            }
            object = (List)destination$iv$iv;
        } else if (psiElement2 instanceof PsiTypeElement) {
            PsiType psiType = ((PsiTypeElement)psiElement).getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            object = this.resolvePsiType(psiType);
        } else if (psiElement2 instanceof JvmNamedElement) {
            object = ((JvmNamedElement)psiElement).getName();
        } else if (nullIfUnResolved) {
            log.info((Function0)new Function0<Object>(psiElement){
                final /* synthetic */ PsiElement $psiElement;
                {
                    this.$psiElement = $psiElement;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "\u672a\u6210\u529f\u89e3\u6790 element: " + this.$psiElement + ", \u6309\u7167\u8bbe\u7f6e,\u8fd4\u56de null";
                }
            });
            object = null;
        } else {
            throw new PsiResolveException("\u6682\u4e0d\u652f\u6301\u7684\u503c\u7c7b\u578b\uff1a " + psiElement.getClass().getSimpleName() + ", \u6587\u672c\uff1a" + psiElement.getText());
        }
        return object;
    }

    public static /* synthetic */ Object resolvePsiVal$default(PsiExpressionResolver psiExpressionResolver, PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return psiExpressionResolver.resolvePsiVal(psiElement, bl);
    }

    private final Object resolvePsiAnnotation(PsiAnnotation psiElement) {
        return AnnotationUtilsKt.attrsToMap(psiElement);
    }

    private final Object resolveLocalVariable(PsiLocalVariable psiVariable) {
        Object object;
        block3: {
            block2: {
                object = psiVariable.getInitializer();
                if (object == null) break block2;
                PsiExpression it = object;
                boolean bl = false;
                Object object2 = PsiExpressionResolver.resolvePsiExpression$default(INSTANCE, it, false, 2, null);
                object = object2;
                if (object2 != null) break block3;
            }
            object = psiVariable.getText();
        }
        return object;
    }

    private final Object resolveVariable(PsiVariable psiVariable) {
        Object constantValue = psiVariable.computeConstantValue();
        if (constantValue != null && !Intrinsics.areEqual((Object)constantValue, (Object)psiVariable)) {
            return this.resolveVal(constantValue);
        }
        return psiVariable.getName();
    }

    private final Map<String, Object> resolveEnumFields(PsiEnumConstant value) {
        Map<String, Object> map = PsiConstEnumUtils.INSTANCE.resolveEnumFields(0, (PsiField)value);
        if (map == null) {
            return null;
        }
        Map<String, Object> constantInfo = map;
        Object object = constantInfo.get("params");
        return object instanceof Map ? (Map)object : null;
    }

    private final Object resolvePsiField(PsiField psiField) {
        Object object;
        if (PsiExtKt.isStaticFinal(psiField)) {
            object = this.resolveStaticField(psiField);
        } else {
            PsiExpression psiExpression = psiField.getInitializer();
            if (psiExpression != null) {
                PsiExpression it = psiExpression;
                boolean bl = false;
                return PsiExpressionResolver.resolvePsiExpression$default(INSTANCE, it, false, 2, null);
            }
            object = psiField.getText();
        }
        return object;
    }

    private final Object resolveStaticField(PsiField psiField) {
        Object constantVal = psiField.computeConstantValue();
        if (constantVal != null) {
            return constantVal;
        }
        PsiExpression initializer = psiField.getInitializer();
        if (initializer != null) {
            return PsiExpressionResolver.resolvePsiExpression$default(this, initializer, false, 2, null);
        }
        return psiField.getText();
    }

    private final Object resolvePsiType(PsiType psiType) {
        String string = psiType.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"<", (boolean)false, (int)2, null)) {
            return psiType;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType);
        if (psiClass == null) {
            psiClass = psiType;
        }
        return psiClass;
    }

    private final Object resolvePsiExpression(PsiExpression psiExpression, boolean nullIfUnResolved) {
        Object object;
        PsiExpression psiExpression2 = psiExpression;
        if (psiExpression2 instanceof PsiAnnotation) {
            object = this.resolvePsiAnnotation((PsiAnnotation)psiExpression);
        } else if (psiExpression2 instanceof PsiReferenceExpression) {
            object = this.resolveReferenceExpression((PsiReferenceExpression)psiExpression);
        } else if (psiExpression2 instanceof PsiLiteralValue) {
            object = ((PsiLiteralValue)psiExpression).getValue();
        } else if (psiExpression2 instanceof PsiBinaryExpression) {
            object = this.resolveBinaryExpression((PsiBinaryExpression)psiExpression);
        } else if (psiExpression2 instanceof PsiPolyadicExpression) {
            object = this.resolvePolyadicExpression((PsiPolyadicExpression)psiExpression);
        } else if (psiExpression2 instanceof PsiUnaryExpression) {
            object = this.resolveUnaryExpression((PsiUnaryExpression)psiExpression);
        } else if (psiExpression2 instanceof PsiLambdaExpression) {
            object = this.resolveLambdaExpression((PsiLambdaExpression)psiExpression);
        } else if (psiExpression2 instanceof PsiClassObjectAccessExpression) {
            object = this.resolveClassObjectAccessExpression((PsiClassObjectAccessExpression)psiExpression);
        } else if (psiExpression2 instanceof PsiArrayAccessExpression) {
            object = this.resolveArrayAccessExpression((PsiArrayAccessExpression)psiExpression);
        } else if (psiExpression2 instanceof JvmNamedElement) {
            object = ((JvmNamedElement)psiExpression).getName();
        } else if (nullIfUnResolved) {
            log.info((Function0)new Function0<Object>(psiExpression){
                final /* synthetic */ PsiExpression $psiExpression;
                {
                    this.$psiExpression = $psiExpression;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "\u672a\u6210\u529f\u89e3\u6790 expression: " + this.$psiExpression + ", \u6309\u7167\u8bbe\u7f6e,\u8fd4\u56de null";
                }
            });
            object = null;
        } else {
            log.error((Function0)new Function0<Object>(psiExpression){
                final /* synthetic */ PsiExpression $psiExpression;
                {
                    this.$psiExpression = $psiExpression;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "\u672a\u6210\u529f\u89e3\u6790 expression: " + this.$psiExpression;
                }
            });
            object = psiExpression.getText();
        }
        return object;
    }

    static /* synthetic */ Object resolvePsiExpression$default(PsiExpressionResolver psiExpressionResolver, PsiExpression psiExpression, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return psiExpressionResolver.resolvePsiExpression(psiExpression, bl);
    }

    private final Object resolveReferenceExpression(PsiReferenceExpression psiExpression) {
        Object object;
        block6: {
            block5: {
                PsiElement psiElement;
                PsiElement psiElement2 = psiExpression.resolve();
                if (psiElement2 == null) {
                    psiElement2 = (PsiElement)psiExpression.getQualifierExpression();
                }
                if ((object = (psiElement = psiElement2)) == null) break block5;
                PsiElement it = object;
                boolean bl = false;
                Object object2 = PsiExpressionResolver.resolvePsiVal$default(INSTANCE, it, false, 2, null);
                object = object2;
                if (object2 != null) break block6;
            }
            return psiExpression.getText();
        }
        Object resolvedValue = object;
        if (resolvedValue instanceof Map && ((Map)resolvedValue).isEmpty()) {
            return psiExpression.getText();
        }
        return resolvedValue;
    }

    private final Object resolveBinaryExpression(PsiBinaryExpression psiExpression) {
        Object object;
        PsiJavaToken psiJavaToken = psiExpression.getOperationSign();
        Intrinsics.checkNotNullExpressionValue((Object)psiJavaToken, (String)"getOperationSign(...)");
        PsiJavaToken op = psiJavaToken;
        IElementType iElementType = op.getTokenType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
        Operator operator = Operator.Companion.getOperator(iElementType);
        if (operator == null) {
            return null;
        }
        Operator operand = operator;
        PsiExpression psiExpression2 = psiExpression.getLOperand();
        Intrinsics.checkNotNullExpressionValue((Object)psiExpression2, (String)"getLOperand(...)");
        Object lOperand = PsiExpressionResolver.resolvePsiExpression$default(this, psiExpression2, false, 2, null);
        PsiExpression psiExpression3 = psiExpression.getROperand();
        if (psiExpression3 != null) {
            PsiExpression it = psiExpression3;
            boolean bl = false;
            object = PsiExpressionResolver.resolvePsiExpression$default(INSTANCE, it, false, 2, null);
        } else {
            object = null;
        }
        Object rOperand = object;
        return operand.apply(lOperand, rOperand);
    }

    /*
     * WARNING - void declaration
     */
    private final Object resolvePolyadicExpression(PsiPolyadicExpression psiExpression) {
        Object v3;
        void $this$reduceOrNull$iv;
        void $this$mapTo$iv$iv;
        IElementType iElementType = psiExpression.getOperationTokenType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationTokenType(...)");
        IElementType op = iElementType;
        Operator operator = Operator.Companion.getOperator(op);
        if (operator == null) {
            return null;
        }
        Operator operand = operator;
        PsiExpression[] psiExpressionArray = psiExpression.getOperands();
        Intrinsics.checkNotNullExpressionValue((Object)psiExpressionArray, (String)"getOperands(...)");
        Object $this$map$iv = psiExpressionArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
        boolean $i$f$mapTo2 = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiExpression psiExpression2 = (PsiExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(PsiExpressionResolver.resolvePsiExpression$default(INSTANCE, (PsiExpression)it, false, 2, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void any;
                Object $i$f$mapTo2 = iterator$iv.next();
                Object acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = operand.apply(acc, any);
            }
            v3 = accumulator$iv;
        }
        return v3;
    }

    private final Object resolveUnaryExpression(PsiUnaryExpression psiExpression) {
        Object object;
        PsiJavaToken op;
        block6: {
            block5: {
                PsiJavaToken psiJavaToken = psiExpression.getOperationSign();
                Intrinsics.checkNotNullExpressionValue((Object)psiJavaToken, (String)"getOperationSign(...)");
                op = psiJavaToken;
                object = psiExpression.getOperand();
                if (object == null) break block5;
                PsiExpression it = object;
                boolean bl = false;
                Object object2 = PsiExpressionResolver.resolvePsiExpression$default(INSTANCE, it, false, 2, null);
                object = object2;
                if (object2 != null) break block6;
            }
            return null;
        }
        Object operand = object;
        IElementType iElementType = op.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.MINUS)) {
            Object object3 = operand;
            return object3 instanceof Integer ? (Number)(-((Number)operand).intValue()) : (Number)(object3 instanceof Long ? (Number)(-((Number)operand).longValue()) : (Number)(object3 instanceof Short ? (Number)Integer.valueOf(-((Number)operand).shortValue()) : (Number)(object3 instanceof Byte ? (Number)Integer.valueOf(-((Number)operand).byteValue()) : (Number)(object3 instanceof Float ? (Number)Float.valueOf(-((Number)operand).floatValue()) : (Number)(object3 instanceof Double ? Double.valueOf(-((Number)operand).doubleValue()) : operand)))));
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.EQEQ) ? true : Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.NE)) {
            return true;
        }
        return operand;
    }

    private final Object resolveLambdaExpression(PsiLambdaExpression psiExpression) {
        Object object;
        PsiElement psiElement = psiExpression.getBody();
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            object = PsiExpressionResolver.resolvePsiVal$default(INSTANCE, it, false, 2, null);
        } else {
            object = null;
        }
        return object;
    }

    private final Object resolveClassObjectAccessExpression(PsiClassObjectAccessExpression psiExpression) {
        PsiElement lastChild = psiExpression.getLastChild();
        if (psiExpression.getChildren().length == 1) {
            return PsiExpressionResolver.resolvePsiVal$default(this, lastChild, false, 2, null);
        }
        if (lastChild instanceof PsiKeyword && Intrinsics.areEqual((Object)((PsiKeyword)lastChild).getText(), (Object)"class")) {
            return PsiExpressionResolver.resolvePsiVal$default(this, psiExpression.getFirstChild(), false, 2, null);
        }
        return psiExpression.getText();
    }

    private final Object resolveArrayAccessExpression(PsiArrayAccessExpression psiExpression) {
        block5: {
            Object index;
            Object object;
            Object array;
            block7: {
                block6: {
                    PsiExpression psiExpression2 = psiExpression.getArrayExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)psiExpression2, (String)"getArrayExpression(...)");
                    Object object2 = PsiExpressionResolver.resolvePsiExpression$default(this, psiExpression2, false, 2, null);
                    if (object2 == null) {
                        return null;
                    }
                    array = object2;
                    if (!(array instanceof Object[]) || ((Object[])array).length <= 0) break block5;
                    object = psiExpression.getIndexExpression();
                    if (object == null) break block6;
                    PsiExpression it = object;
                    boolean bl = false;
                    Object object3 = PsiExpressionResolver.resolvePsiExpression$default(INSTANCE, it, false, 2, null);
                    object = object3;
                    if (object3 != null) break block7;
                }
                object = 0;
            }
            if (!((index = object) instanceof Integer)) {
                index = 0;
            }
            return ((Object[])array)[((Number)index).intValue()];
        }
        return psiExpression.getText();
    }

    private final Object tryComputeConst(PsiExpression psiExpression) {
        try {
            Object value = ExpressionUtils.computeConstantExpression((PsiExpression)psiExpression, (boolean)true);
            if (value == null && !Intrinsics.areEqual((Object)psiExpression.getText(), (Object)"null")) {
                throw new PsiResolveException("\u672a\u6210\u529f\u89e3\u6790\u8868\u8fbe\u5f0f\uff1a" + psiExpression.getText());
            }
            return value;
        }
        catch (ConstantEvaluationOverflowException e) {
            throw new PsiResolveException("\u672a\u6210\u529f\u89e3\u6790\u8868\u8fbe\u5f0f\uff1a" + psiExpression.getText());
        }
    }
}

