/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.ide.csi.model;

import com.alibaba.bizworks.ide.common.utils.FqnUtils;
import com.alibaba.bizworks.ide.csi.CsiQualifiedNamedElement;
import com.alibaba.bizworks.ide.csi.consts.CsiTypeKind;
import com.alibaba.bizworks.ide.csi.model.CsiClass;
import com.alibaba.bizworks.ide.csi.support.AbstractAnnotationOwner;

public class CsiType
extends AbstractAnnotationOwner
implements CsiQualifiedNamedElement {
    private String className;
    private String packageName;
    private CsiClass cls;
    private CsiTypeKind kind;
    private boolean resolvable;

    public void setClassName(String className) {
        this.className = className;
        this.setName(className);
    }

    public static CsiType from(CsiClass cls) {
        CsiType type = new CsiType();
        type.setClass(cls);
        return type;
    }

    public void setClass(CsiClass cls) {
        this.className = cls.getName();
        this.packageName = cls.getPackageName();
        this.cls = cls;
        this.resolvable = true;
        this.kind = CsiTypeKind.CLASS;
    }

    public CsiClass resolve() {
        if (!this.resolvable) {
            // empty if block
        }
        return this.cls;
    }

    public boolean isPrimitive() {
        return CsiTypeKind.PRIMITIVE.equals((Object)this.kind);
    }

    @Override
    public String getQualifiedName() {
        return FqnUtils.toQualifiedName((String)this.packageName, (String)this.className);
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}

