/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight;

import com.alibaba.bizworks.codeinsight.adl.AdlBoundedContext;
import com.alibaba.bizworks.codeinsight.adl.AdlCodeGenModel;
import com.alibaba.bizworks.codeinsight.adl.AdlDeclaration;
import com.alibaba.bizworks.codeinsight.adl.AdlID;
import com.alibaba.bizworks.codeinsight.generator.java.CompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.CompilationUnitGeneratorFactory;
import com.alibaba.bizworks.codeinsight.generator.java.GeneratedCodeMeta;
import com.alibaba.bizworks.codeinsight.generator.maven.GeneratedPomMeta;
import com.alibaba.bizworks.codeinsight.generator.maven.GeneratedSettingsMeta;
import com.alibaba.bizworks.codeinsight.generator.maven.MavenGeneratorFactory;
import com.alibaba.bizworks.codeinsight.generator.maven.PomGenerator;
import com.alibaba.bizworks.codeinsight.generator.maven.SettingsGenerator;
import com.alibaba.bizworks.codeinsight.generator.springboot.ApplicationConfigGenerator;
import com.alibaba.bizworks.codeinsight.generator.springboot.GeneratedApplicationConfigMeta;
import com.alibaba.bizworks.codeinsight.generator.springboot.SpringBootGeneratorFactory;
import com.alibaba.bizworks.codeinsight.model.ApplicationConfig;
import com.alibaba.bizworks.codeinsight.utils.MavenUtils;
import com.alibaba.bizworks.codeinsight.utils.ModuleMeta;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import com.alibaba.bizworks.codeinsight.utils.YamlUtils;
import com.github.javaparser.utils.SourceRoot;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;

public class DefaultSourceGenerator {
    public void generate(AdlCodeGenModel adlCodeGenModel, ProjectMeta projectMeta) {
        this.generate(adlCodeGenModel, projectMeta, true);
    }

    public void generate(AdlCodeGenModel adlCodeGenModel, ProjectMeta projectMeta, boolean full) {
        ModuleMeta moduleMeta;
        String boundedContextNameText;
        AdlID boundedContextName;
        ArrayList<GeneratedPomMeta> generatedPomMetas = new ArrayList<GeneratedPomMeta>();
        ArrayList<GeneratedCodeMeta> generatedCodeMetas = new ArrayList<GeneratedCodeMeta>();
        GeneratedSettingsMeta generatedSettingsMeta = null;
        if (full) {
            SettingsGenerator settingsGenerator = MavenGeneratorFactory.createSettingsGenerator(projectMeta);
            generatedSettingsMeta = settingsGenerator.generate();
        }
        GeneratedPomMeta rootPomMeta = null;
        if (full) {
            PomGenerator projectRootPomGenerator = MavenGeneratorFactory.createProjectRootPomGenerator(projectMeta);
            rootPomMeta = projectRootPomGenerator.generate().get(0);
        } else {
            String rootPomPath = projectMeta.getParentRootPath() + "/" + projectMeta.getProjectName() + "/pom.xml";
            Model rootPomModel = MavenUtils.load(rootPomPath);
            rootPomMeta = new GeneratedPomMeta(rootPomModel, rootPomPath);
        }
        generatedPomMetas.add(rootPomMeta);
        GeneratedPomMeta starterPomMeta = null;
        if (full) {
            PomGenerator starterPomGenerator = MavenGeneratorFactory.createStarterPomGenerator(projectMeta);
            starterPomMeta = starterPomGenerator.generate().get(0);
        } else {
            String starterPomPath = projectMeta.getProjectRootPath() + "/" + projectMeta.getProjectName() + "-starter/pom.xml";
            Model starterPomModel = MavenUtils.load(starterPomPath);
            starterPomMeta = new GeneratedPomMeta(starterPomModel, starterPomPath);
        }
        generatedPomMetas.add(starterPomMeta);
        ArrayList<GeneratedApplicationConfigMeta> generatedApplicationConfigMetas = new ArrayList();
        if (full) {
            ApplicationConfigGenerator applicationConfigGenerator = SpringBootGeneratorFactory.createProjectRootPomGenerator(projectMeta);
            generatedApplicationConfigMetas = applicationConfigGenerator.generate();
        }
        if (full) {
            CompilationUnitGenerator mainAppGenerator = CompilationUnitGeneratorFactory.createMainApp(projectMeta);
            generatedCodeMetas.addAll(mainAppGenerator.generate());
        }
        CompilationUnitGenerator swaggerConfigGenerator = CompilationUnitGeneratorFactory.createSwaggerConfig(projectMeta);
        generatedCodeMetas.addAll(swaggerConfigGenerator.generate());
        List<AdlBoundedContext> boundedContexts = adlCodeGenModel.getBoundedContexts();
        if (boundedContexts == null || boundedContexts.isEmpty()) {
            return;
        }
        for (AdlBoundedContext boundedContext : boundedContexts) {
            boundedContextName = boundedContext.getName();
            boundedContextNameText = boundedContextName.getText();
            moduleMeta = ModuleMeta.Builder.create().boundContextName(boundedContextNameText).build();
            PomGenerator boundedContextPomGenerator = MavenGeneratorFactory.createBoundedContextPomGenerator(projectMeta, moduleMeta);
            generatedPomMetas.addAll(boundedContextPomGenerator.generate());
            List<AdlDeclaration> adlDeclarations = boundedContext.getDecls();
            if (adlDeclarations == null || adlDeclarations.isEmpty()) continue;
            for (AdlDeclaration adlDeclaration : adlDeclarations) {
                CompilationUnitGenerator generator = CompilationUnitGeneratorFactory.create(adlDeclaration, projectMeta, moduleMeta);
                generatedCodeMetas.addAll(generator.generate());
            }
        }
        for (AdlBoundedContext boundedContext : boundedContexts) {
            boundedContextName = boundedContext.getName();
            boundedContextNameText = boundedContextName.getText();
            moduleMeta = ModuleMeta.Builder.create().boundContextName(boundedContextNameText).build();
            if (!rootPomMeta.getModel().getModules().contains(moduleMeta.getBoundContextNameAsCode())) {
                rootPomMeta.getModel().addModule(moduleMeta.getBoundContextNameAsCode());
            }
            String bdctxEntryModuleName = moduleMeta.getBoundContextNameAsCode() + "-entry";
            Dependency entryDependency = new Dependency();
            entryDependency.setGroupId(projectMeta.getGroupId());
            entryDependency.setArtifactId(bdctxEntryModuleName);
            entryDependency.setVersion(projectMeta.getVersion());
            if (!this.containsDependency(starterPomMeta.getModel().getDependencies(), entryDependency)) {
                starterPomMeta.getModel().addDependency(entryDependency);
            }
            String bdctxServiceImplModuleName = moduleMeta.getBoundContextNameAsCode() + "-service-impl";
            Dependency serviceImplDependency = new Dependency();
            serviceImplDependency.setGroupId(projectMeta.getGroupId());
            serviceImplDependency.setArtifactId(bdctxServiceImplModuleName);
            serviceImplDependency.setVersion(projectMeta.getVersion());
            if (this.containsDependency(starterPomMeta.getModel().getDependencies(), serviceImplDependency)) continue;
            starterPomMeta.getModel().addDependency(serviceImplDependency);
        }
        String starterModuleName = projectMeta.getAppName() + "-starter";
        if (!rootPomMeta.getModel().getModules().contains(starterModuleName)) {
            rootPomMeta.getModel().addModule(starterModuleName);
        } else {
            rootPomMeta.getModel().getModules().remove(starterModuleName);
            rootPomMeta.getModel().addModule(starterModuleName);
        }
        DefaultSourceGenerator.saveGeneratedSettings(generatedSettingsMeta);
        this.saveGeneratedPoms(generatedPomMetas);
        this.saveGeneratedApplicationConfigIntoYaml(generatedApplicationConfigMetas);
        this.saveGeneratedCodes(generatedCodeMetas);
    }

    private boolean containsDependency(List<Dependency> dependencies, Dependency dependency) {
        if (dependencies == null || dependencies.isEmpty()) {
            return false;
        }
        for (Dependency dep : dependencies) {
            if (!dep.getGroupId().equals(dependency.getGroupId()) || !dep.getArtifactId().equals(dependency.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private void saveGeneratedApplicationConfigIntoYaml(List<GeneratedApplicationConfigMeta> generatedApplicationConfigMetas) {
        if (generatedApplicationConfigMetas == null || generatedApplicationConfigMetas.isEmpty()) {
            return;
        }
        for (GeneratedApplicationConfigMeta meta : generatedApplicationConfigMetas) {
            if (meta == null) continue;
            ApplicationConfig config = meta.getApplicationConfig();
            String path = meta.getPath();
            YamlUtils.saveYaml(config, path);
        }
    }

    private static void saveGeneratedSettings(GeneratedSettingsMeta generatedSettingsMeta) {
        if (generatedSettingsMeta == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(generatedSettingsMeta.getPath());){
            writer.write(generatedSettingsMeta.getContent());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveGeneratedPoms(List<GeneratedPomMeta> generatedPomMetas) {
        for (GeneratedPomMeta generatedPomMeta : generatedPomMetas) {
            if (generatedPomMeta == null) continue;
            try {
                FileWriter writer = new FileWriter(generatedPomMeta.getPath());
                Throwable throwable = null;
                try {
                    new MavenXpp3Writer().write((Writer)writer, generatedPomMeta.getModel());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveGeneratedCodes(List<GeneratedCodeMeta> generatedCodeMetas) {
        for (GeneratedCodeMeta generatedCodeMeta : generatedCodeMetas) {
            if (generatedCodeMeta == null) continue;
            SourceRoot sr = new SourceRoot(Paths.get(generatedCodeMeta.getPath(), new String[0]));
            sr.add(generatedCodeMeta.getPackageName(), generatedCodeMeta.getClassName() + ".java", generatedCodeMeta.getCompilationUnit());
            sr.saveAll();
        }
    }
}

