/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;

public class MavenProjectParser {
    public static void main(String[] args) {
        String projectRoot = "/Users/hashen/Downloads/test/sxjcy/x/sxjc-platform";
        try {
            MavenProjectParser.parseProject(new File(projectRoot));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void parseProject(File projectDirectory) throws IOException {
        if (!projectDirectory.isDirectory()) {
            throw new IllegalArgumentException("Provided path is not a directory");
        }
        JavaParser javaParser = new JavaParser(new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17));
        try (Stream<Path> paths = Files.walk(projectDirectory.toPath(), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".java")).forEach(path -> MavenProjectParser.parseJavaFile(javaParser, path.toFile()));
        }
    }

    private static void parseJavaFile(JavaParser javaParser, File javaFile) {
        try {
            ParseResult parseResult = javaParser.parse(javaFile);
            if (parseResult.isSuccessful() && parseResult.getResult().isPresent()) {
                CompilationUnit compilationUnit = (CompilationUnit)parseResult.getResult().get();
                ClassNamePrinter classNameVisitor = new ClassNamePrinter();
                classNameVisitor.visit(compilationUnit, null);
            } else {
                parseResult.getProblems().forEach(problem -> System.out.println("Parsing problem: " + problem.getMessage()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ClassNamePrinter
    extends VoidVisitorAdapter<Void> {
        private ClassNamePrinter() {
        }

        public void visit(ClassOrInterfaceDeclaration cid, Void arg) {
            super.visit(cid, (Object)arg);
            System.out.println("Class or interface: " + cid.getNameAsString());
        }
    }
}

