/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.generator.java;

import com.alibaba.bizworks.codeinsight.adl.AdlDeclaration;
import com.alibaba.bizworks.codeinsight.adl.AdlNodeType;
import com.alibaba.bizworks.codeinsight.generator.java.ApplicationServiceCompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.CompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.DomainObjectCompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.DomainObjectCurdCompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.MainAppCompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.StructureObjectCompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.SwaggerConfigCompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.utils.ModuleMeta;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import java.util.Objects;

public class CompilationUnitGeneratorFactory {
    private CompilationUnitGeneratorFactory() {
    }

    public static CompilationUnitGenerator create(AdlDeclaration adlDeclaration, ProjectMeta projectMeta, ModuleMeta moduleMeta) {
        switch (Objects.requireNonNull(AdlNodeType.fromValue(adlDeclaration.getNodeType()))) {
            case EntityDecl: {
                if (CompilationUnitGeneratorFactory.isCurdRequired(adlDeclaration)) {
                    return new DomainObjectCurdCompilationUnitGenerator(adlDeclaration, projectMeta, moduleMeta);
                }
                return new DomainObjectCompilationUnitGenerator(adlDeclaration, projectMeta, moduleMeta);
            }
            case ServiceDecl: {
                return new ApplicationServiceCompilationUnitGenerator(adlDeclaration, projectMeta, moduleMeta);
            }
            case StructDecl: {
                return new StructureObjectCompilationUnitGenerator(adlDeclaration, projectMeta, moduleMeta);
            }
        }
        throw new IllegalArgumentException("Unsupported ADL node type: " + adlDeclaration.getNodeType());
    }

    private static boolean isCurdRequired(AdlDeclaration adlDeclaration) {
        if (adlDeclaration.getAnnotations() == null) {
            return false;
        }
        if (adlDeclaration.getAnnotations().isEmpty()) {
            return false;
        }
        return adlDeclaration.getAnnotations().stream().anyMatch(annotation -> "curd".equals(annotation.getName().getText()));
    }

    public static CompilationUnitGenerator createMainApp(ProjectMeta projectMeta) {
        return new MainAppCompilationUnitGenerator(projectMeta);
    }

    public static CompilationUnitGenerator createSwaggerConfig(ProjectMeta projectMeta) {
        return new SwaggerConfigCompilationUnitGenerator(projectMeta);
    }
}

