/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.generator.java;

import com.alibaba.bizworks.codeinsight.adl.AdlDeclaration;
import com.alibaba.bizworks.codeinsight.adl.AdlID;
import com.alibaba.bizworks.codeinsight.adl.AdlNodeType;
import com.alibaba.bizworks.codeinsight.adl.AdlType;
import com.alibaba.bizworks.codeinsight.generator.java.ApplicationServiceCompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.DomainObjectCompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.GeneratedCodeMeta;
import com.alibaba.bizworks.codeinsight.utils.AdlTypeConvertor;
import com.alibaba.bizworks.codeinsight.utils.AnnotationMeta;
import com.alibaba.bizworks.codeinsight.utils.ClassMeta;
import com.alibaba.bizworks.codeinsight.utils.JavaParserHelper;
import com.alibaba.bizworks.codeinsight.utils.ModuleMeta;
import com.alibaba.bizworks.codeinsight.utils.PackageHelper;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DomainObjectCurdCompilationUnitGenerator
extends DomainObjectCompilationUnitGenerator {
    DomainObjectCurdCompilationUnitGenerator(AdlDeclaration adlDeclaration, ProjectMeta projectMeta, ModuleMeta moduleMeta) {
        super(adlDeclaration, projectMeta, moduleMeta);
    }

    @Override
    public List<GeneratedCodeMeta> generate() {
        ArrayList<GeneratedCodeMeta> generatedCodeMetas = new ArrayList<GeneratedCodeMeta>();
        generatedCodeMetas.add(this.generateEntity());
        generatedCodeMetas.addAll(this.generateApplicationTier());
        generatedCodeMetas.add(this.generatedDTO());
        return generatedCodeMetas;
    }

    private List<GeneratedCodeMeta> generateApplicationTier() {
        AdlDeclaration theOne = new AdlDeclaration();
        AdlID name = new AdlID();
        String entityName = this.adlDeclaration.getName().getText();
        name.setText(entityName + "Service");
        theOne.setName(name);
        ArrayList<AdlDeclaration> funcList = new ArrayList<AdlDeclaration>();
        funcList.add(this.getFunc("create" + entityName, entityName.substring(0, 1).toLowerCase() + entityName.substring(1), entityName + "DTO", null));
        funcList.add(this.getFunc("retrieve" + entityName, "id", AdlNodeType.StringType.getValue(), entityName + "DTO"));
        funcList.add(this.getFunc("update" + entityName, entityName.substring(0, 1).toLowerCase() + entityName.substring(1), entityName + "DTO", null));
        funcList.add(this.getFunc("delete" + entityName, "id", AdlNodeType.StringType.getValue(), null));
        theOne.setFuncList(funcList);
        return new ApplicationServiceCompilationUnitGenerator(theOne, this.projectMeta, this.moduleMeta).generate();
    }

    private AdlDeclaration getFunc(String methodName, String parameterName, String parameterType, String returnType) {
        AdlDeclaration adlDeclaration = new AdlDeclaration();
        adlDeclaration.setName(this.getAdlID(methodName));
        if (parameterName != null) {
            AdlDeclaration parameter = new AdlDeclaration();
            parameter.setName(this.getAdlID(parameterName));
            parameter.setType(this.getAdlType(parameterType));
            ArrayList<AdlDeclaration> parameters = new ArrayList<AdlDeclaration>();
            parameters.add(parameter);
            adlDeclaration.setParameters(parameters);
        }
        if (returnType != null) {
            adlDeclaration.setType(this.getAdlType(returnType));
        }
        return adlDeclaration;
    }

    private AdlID getAdlID(String text) {
        AdlID adlID = new AdlID();
        adlID.setText(text);
        return adlID;
    }

    private AdlType getAdlType(String text) {
        AdlType adlType = new AdlType();
        AdlNodeType adlNodeType = AdlNodeType.fromValue(text);
        if (adlNodeType == null) {
            adlNodeType = AdlNodeType.UserType;
            adlType.setName(this.getAdlID(text));
        }
        adlType.setNodeType(adlNodeType.getValue());
        return adlType;
    }

    private GeneratedCodeMeta generatedDTO() {
        String cuName = this.adlDeclaration.getName().getText() + "DTO";
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(PackageHelper.getStructureObjectPackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage(), this.moduleMeta.getBoundContextName()));
        ClassOrInterfaceDeclaration cid = cu.addClass(cuName);
        cid.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        if (this.projectMeta.isWithLombok()) {
            JavaParserHelper.addBeanLombokAnnotations(cid, this.adlDeclaration);
        }
        AnnotationMeta domainObjectAnnotationMeta = AnnotationMeta.create("com.alibaba.bizworks.core.specification.StructureObject").addString("name", cuName);
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, domainObjectAnnotationMeta);
        AdlTypeConvertor adlTypeConvertor = new AdlTypeConvertor(this.projectMeta, this.moduleMeta);
        List<AdlDeclaration> memberVarList = this.adlDeclaration.getMemberVarList();
        if (memberVarList != null && !memberVarList.isEmpty()) {
            for (AdlDeclaration memberVar : memberVarList) {
                ClassMeta classMeta = adlTypeConvertor.to(memberVar.getType());
                JavaParserHelper.addField(cid, classMeta, memberVar.getName().getText());
                JavaParserHelper.addImportIfNecessary(cu, classMeta);
            }
        }
        JavaParserHelper.sortImports(cu);
        return new GeneratedCodeMeta(cu, this.getOrCreatePathOfDTO(), ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString(), cuName);
    }

    private String getOrCreatePathOfDTO() {
        String bdctx = this.moduleMeta.getBoundContextNameAsCode();
        String path = this.projectMeta.getProjectRootPath() + "/" + bdctx + "/" + bdctx + "-application/" + bdctx + "-contract/src/main/java";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }
}

