/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.generator.java;

import com.alibaba.bizworks.codeinsight.generator.java.CompilationUnitGenerator;
import com.alibaba.bizworks.codeinsight.generator.java.GeneratedCodeMeta;
import com.alibaba.bizworks.codeinsight.utils.AnnotationMeta;
import com.alibaba.bizworks.codeinsight.utils.JavaParserHelper;
import com.alibaba.bizworks.codeinsight.utils.PackageHelper;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SwaggerConfigCompilationUnitGenerator
implements CompilationUnitGenerator {
    private final ProjectMeta projectMeta;

    public SwaggerConfigCompilationUnitGenerator(ProjectMeta projectMeta) {
        this.projectMeta = projectMeta;
    }

    @Override
    public List<GeneratedCodeMeta> generate() {
        ArrayList<GeneratedCodeMeta> generatedCodeMetas = new ArrayList<GeneratedCodeMeta>();
        generatedCodeMetas.add(this.generateProperties());
        generatedCodeMetas.add(this.generateConfig());
        return generatedCodeMetas;
    }

    private GeneratedCodeMeta generateConfig() {
        String cuName = "SwaggerConfig";
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(PackageHelper.getStarterConfigPackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage()));
        ClassOrInterfaceDeclaration cid = cu.addClass(cuName);
        cid.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        AnnotationMeta configAnno = AnnotationMeta.create("org.springframework.context.annotation.Configuration");
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, configAnno);
        AnnotationMeta openApiAnno = AnnotationMeta.create("springfox.documentation.oas.annotations.EnableOpenApi");
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, openApiAnno);
        NormalAnnotationExpr annotation = new NormalAnnotationExpr();
        annotation.setName("EnableConfigurationProperties");
        ArrayInitializerExpr value = new ArrayInitializerExpr();
        value.getValues().add(new ClassExpr().setType("SwaggerProperties"));
        annotation.addPair("value", (Expression)value);
        cid.addAnnotation((AnnotationExpr)annotation);
        cu.addImport("org.springframework.boot.context.properties.EnableConfigurationProperties");
        FieldDeclaration fieldDeclaration = cid.addField("SwaggerProperties", "swaggerProperties", new Modifier.Keyword[0]);
        JavaParserHelper.addAnnotation((NodeWithAnnotations)fieldDeclaration, AnnotationMeta.create("org.springframework.beans.factory.annotation.Autowired"));
        MethodDeclaration methodDeclaration = ((MethodDeclaration)((MethodDeclaration)cid.addMethod("docket", new Modifier.Keyword[0]).setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setType("Docket")).setBody(JavaParserHelper.parseBlock("{\n        return new Docket(DocumentationType.SWAGGER_2)\n            .enable(swaggerProperties.getEnable())\n            .apiInfo(new ApiInfoBuilder()\n                .title(swaggerProperties.getTitle())\n                .description(swaggerProperties.getDescription())\n                .version(swaggerProperties.getVersion())\n                .build())\n            .select()\n            .apis(RequestHandlerSelectors.basePackage(swaggerProperties.getBasePackage()))\n            .paths(PathSelectors.any())\n            .build();\n    }"));
        AnnotationMeta beanAnno = AnnotationMeta.create("org.springframework.context.annotation.Bean");
        JavaParserHelper.addAnnotation((NodeWithAnnotations)methodDeclaration, beanAnno);
        cu.addImport("springfox.documentation.spring.web.plugins.Docket");
        cu.addImport("springfox.documentation.builders.RequestHandlerSelectors");
        cu.addImport("springfox.documentation.spi.DocumentationType");
        cu.addImport("springfox.documentation.builders.PathSelectors");
        cu.addImport("springfox.documentation.builders.ApiInfoBuilder");
        cu.addImport("org.springframework.context.annotation.Bean");
        JavaParserHelper.sortImports(cu);
        return new GeneratedCodeMeta(cu, this.getOrCreatePath(), ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString(), cuName);
    }

    private GeneratedCodeMeta generateProperties() {
        String cuName = "SwaggerProperties";
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(PackageHelper.getStarterConfigPackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage()));
        ClassOrInterfaceDeclaration cid = cu.addClass(cuName);
        cid.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        if (this.projectMeta.isWithLombok()) {
            JavaParserHelper.addBeanLombokAnnotations(cid);
        }
        AnnotationMeta anno = AnnotationMeta.create("org.springframework.boot.context.properties.ConfigurationProperties").addString("prefix", "spring.swagger");
        JavaParserHelper.addAnnotation((NodeWithAnnotations)cid, anno);
        cid.addPrivateField("String", "title");
        cid.addPrivateField("String", "description");
        cid.addPrivateField("String", "version");
        cid.addPrivateField("String", "basePackage");
        cid.addPrivateField("Boolean", "enable");
        JavaParserHelper.sortImports(cu);
        return new GeneratedCodeMeta(cu, this.getOrCreatePath(), ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString(), cuName);
    }

    private String getOrCreatePath() {
        String appName = this.projectMeta.getAppName();
        String path = this.projectMeta.getProjectRootPath() + "/" + appName + "-starter/src/main/java";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }
}

