/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.generator.maven;

import com.alibaba.bizworks.codeinsight.generator.maven.GeneratedPomMeta;
import com.alibaba.bizworks.codeinsight.generator.maven.PomGenerator;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class StarterPomGenerator
implements PomGenerator {
    private final ProjectMeta projectMeta;

    public StarterPomGenerator(ProjectMeta projectMeta) {
        this.projectMeta = projectMeta;
    }

    @Override
    public List<GeneratedPomMeta> generate() {
        ArrayList generatedPomMetas = Lists.newArrayList();
        generatedPomMetas.add(this.generateStarterPom());
        return generatedPomMetas;
    }

    private GeneratedPomMeta generateStarterPom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        Parent parent = new Parent();
        model.setParent(parent);
        parent.setGroupId(this.projectMeta.getGroupId());
        parent.setArtifactId(this.projectMeta.getArtifactId());
        parent.setVersion(this.projectMeta.getVersion());
        model.setArtifactId(this.projectMeta.getAppName() + "-starter");
        model.setVersion(this.projectMeta.getVersion());
        model.setPackaging("jar");
        ArrayList dependencies = Lists.newArrayList();
        Dependency bwafCoreTrafficLogging = new Dependency();
        bwafCoreTrafficLogging.setGroupId("com.alibaba.bizworks");
        bwafCoreTrafficLogging.setArtifactId("bwaf-core-traffic-logging");
        dependencies.add(bwafCoreTrafficLogging);
        Dependency mybatisPlusBootStarter = new Dependency();
        mybatisPlusBootStarter.setGroupId("com.baomidou");
        mybatisPlusBootStarter.setArtifactId("mybatis-plus-boot-starter");
        dependencies.add(mybatisPlusBootStarter);
        Dependency h2 = new Dependency();
        h2.setGroupId("com.h2database");
        h2.setArtifactId("h2");
        dependencies.add(h2);
        Dependency springBootDevtools = new Dependency();
        springBootDevtools.setGroupId("org.springframework.boot");
        springBootDevtools.setArtifactId("spring-boot-devtools");
        dependencies.add(springBootDevtools);
        Dependency springCloudStarterOpenfeign = new Dependency();
        springCloudStarterOpenfeign.setGroupId("org.springframework.cloud");
        springCloudStarterOpenfeign.setArtifactId("spring-cloud-starter-openfeign");
        dependencies.add(springCloudStarterOpenfeign);
        Dependency springBootStarterWeb = new Dependency();
        springBootStarterWeb.setGroupId("org.springframework.boot");
        springBootStarterWeb.setArtifactId("spring-boot-starter-web");
        dependencies.add(springBootStarterWeb);
        Dependency springBootStarterValidation = new Dependency();
        springBootStarterValidation.setGroupId("org.springframework.boot");
        springBootStarterValidation.setArtifactId("spring-boot-starter-validation");
        dependencies.add(springBootStarterValidation);
        model.setDependencies((List)dependencies);
        Build build = new Build();
        model.setBuild(build);
        ArrayList plugins = Lists.newArrayList();
        Plugin mavenCompilerPlugin = new Plugin();
        mavenCompilerPlugin.setGroupId("org.apache.maven.plugins");
        mavenCompilerPlugin.setArtifactId("maven-compiler-plugin");
        mavenCompilerPlugin.setVersion("3.5.1");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom source = new Xpp3Dom("source");
        source.setValue("1.8");
        configuration.addChild(source);
        Xpp3Dom target = new Xpp3Dom("target");
        target.setValue("1.8");
        configuration.addChild(target);
        mavenCompilerPlugin.setConfiguration((Object)configuration);
        plugins.add(mavenCompilerPlugin);
        Plugin springBootMavenPlugin = new Plugin();
        springBootMavenPlugin.setGroupId("org.springframework.boot");
        springBootMavenPlugin.setArtifactId("spring-boot-maven-plugin");
        ArrayList executions = Lists.newArrayList();
        PluginExecution execution = new PluginExecution();
        Xpp3Dom goals = new Xpp3Dom("goals");
        Xpp3Dom goal = new Xpp3Dom("goal");
        goal.setValue("repackage");
        goals.addChild(goal);
        execution.addGoal("repackage");
        executions.add(execution);
        springBootMavenPlugin.setExecutions((List)executions);
        plugins.add(springBootMavenPlugin);
        build.setPlugins((List)plugins);
        ArrayList resources = Lists.newArrayList();
        build.setResources((List)resources);
        Resource bizworksResource = new Resource();
        bizworksResource.setDirectory("../.bizworks");
        bizworksResource.setTargetPath(".bizworks");
        resources.add(bizworksResource);
        Resource mainResource = new Resource();
        mainResource.setDirectory("src/main/resources");
        resources.add(mainResource);
        return new GeneratedPomMeta(model, this.getOrCreatePathAndFile());
    }

    private String getOrCreatePathAndFile() {
        String path = this.projectMeta.getProjectRootPath() + "/" + this.projectMeta.getAppName() + "-starter";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path + "/pom.xml";
    }
}

