/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.generator.springboot;

import com.alibaba.bizworks.codeinsight.generator.springboot.ApplicationConfigGenerator;
import com.alibaba.bizworks.codeinsight.generator.springboot.GeneratedApplicationConfigMeta;
import com.alibaba.bizworks.codeinsight.model.ApplicationConfig;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DefaultApplicationConfigGenerator
implements ApplicationConfigGenerator {
    private final ProjectMeta projectMeta;

    public DefaultApplicationConfigGenerator(ProjectMeta projectMeta) {
        this.projectMeta = projectMeta;
    }

    @Override
    public List<GeneratedApplicationConfigMeta> generate() {
        ArrayList<GeneratedApplicationConfigMeta> metas = new ArrayList<GeneratedApplicationConfigMeta>();
        metas.add(this.generateMain());
        metas.add(this.generateLocal());
        return metas;
    }

    private GeneratedApplicationConfigMeta generateLocal() {
        ApplicationConfig config = new ApplicationConfig();
        ApplicationConfig.ServerConfig serverConfig = new ApplicationConfig.ServerConfig();
        serverConfig.setPort(8080);
        config.setServer(serverConfig);
        ApplicationConfig.ProjectConfig projectConfig = new ApplicationConfig.ProjectConfig();
        projectConfig.setName(this.projectMeta.getAppName());
        config.setProject(projectConfig);
        ApplicationConfig.SpringConfig springConfig = new ApplicationConfig.SpringConfig();
        ApplicationConfig.SpringConfig.DataSourceConfig datasourceConfig = new ApplicationConfig.SpringConfig.DataSourceConfig();
        datasourceConfig.setDriverClassName("org.h2.Driver");
        datasourceConfig.setUrl("jdbc:h2:~/test;MODE=MySQL");
        datasourceConfig.setUsername("sa");
        datasourceConfig.setPassword("");
        springConfig.setDatasource(datasourceConfig);
        ApplicationConfig.SpringConfig.SwaggerConfig swaggerConfig = new ApplicationConfig.SpringConfig.SwaggerConfig();
        swaggerConfig.setEnable(true);
        swaggerConfig.setBasePackage(this.projectMeta.getGroupId() + "." + this.projectMeta.getArtifactIdForPackage());
        swaggerConfig.setVersion("1.0.0");
        swaggerConfig.setTitle("\u6d4b\u8bd5\u6807\u9898");
        swaggerConfig.setDescription("\u6d4b\u8bd5\u63cf\u8ff0");
        springConfig.setSwagger(swaggerConfig);
        ApplicationConfig.SpringConfig.H2Config h2Config = new ApplicationConfig.SpringConfig.H2Config();
        ApplicationConfig.SpringConfig.H2Config.ConsoleConfig consoleConfig = new ApplicationConfig.SpringConfig.H2Config.ConsoleConfig();
        HashMap<String, Boolean> settings = new HashMap<String, Boolean>();
        settings.put("web-allow-others", true);
        settings.put("trace", false);
        consoleConfig.setSettings(settings);
        consoleConfig.setPath("/h2-console");
        consoleConfig.setEnable(true);
        h2Config.setConsole(consoleConfig);
        springConfig.setH2(h2Config);
        config.setSpring(springConfig);
        ApplicationConfig.BizworksConfig bizworksConfig = new ApplicationConfig.BizworksConfig();
        bizworksConfig.setAppId(this.projectMeta.getAppName());
        bizworksConfig.setTenantId("replacedByBizworks");
        config.setBizworks(bizworksConfig);
        ApplicationConfig.FeignConfig feignConfig = new ApplicationConfig.FeignConfig();
        ApplicationConfig.FeignConfig.HttpClientConfig httpClientConfig = new ApplicationConfig.FeignConfig.HttpClientConfig();
        httpClientConfig.setEnabled(true);
        httpClientConfig.setConnectionTimeout(3000);
        httpClientConfig.setMaxConnections(500);
        httpClientConfig.setMaxConnectionsPerRoute(200);
        feignConfig.setHttpclient(httpClientConfig);
        config.setFeign(feignConfig);
        ApplicationConfig.MybatisPlusConfig mybatisPlusConfig = new ApplicationConfig.MybatisPlusConfig();
        mybatisPlusConfig.setMapperLocations("classpath*:com/gitee/sunchenbin/mybatis/actable/mapping/*/*.xml");
        config.setMybatisPlus(mybatisPlusConfig);
        return new GeneratedApplicationConfigMeta(config, this.getOrCreateLocalPath());
    }

    private GeneratedApplicationConfigMeta generateMain() {
        ApplicationConfig config = new ApplicationConfig();
        ApplicationConfig.SpringConfig.ProfilesConfig profilesConfig = new ApplicationConfig.SpringConfig.ProfilesConfig();
        profilesConfig.setActive("local");
        ApplicationConfig.SpringConfig springConfig = new ApplicationConfig.SpringConfig();
        springConfig.setProfiles(profilesConfig);
        config.setSpring(springConfig);
        return new GeneratedApplicationConfigMeta(config, this.getOrCreateMainPath());
    }

    private String getOrCreateMainPath() {
        String appName = this.projectMeta.getAppName();
        String path = this.projectMeta.getProjectRootPath() + "/" + appName + "-starter/src/main/resources";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path + "/application.yml";
    }

    private String getOrCreateLocalPath() {
        String appName = this.projectMeta.getAppName();
        String path = this.projectMeta.getProjectRootPath() + "/" + appName + "-starter/src/main/resources";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path + "/application-local.yml";
    }
}

