/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.utils;

import com.alibaba.bizworks.codeinsight.adl.AdlID;
import com.alibaba.bizworks.codeinsight.adl.AdlNodeType;
import com.alibaba.bizworks.codeinsight.adl.AdlType;
import com.alibaba.bizworks.codeinsight.utils.ClassMeta;
import com.alibaba.bizworks.codeinsight.utils.ModuleMeta;
import com.alibaba.bizworks.codeinsight.utils.PackageHelper;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AdlTypeConvertor {
    private ProjectMeta projectMeta;
    private ModuleMeta moduleMeta;

    public AdlTypeConvertor(ProjectMeta projectMeta, ModuleMeta moduleMeta) {
        this.projectMeta = projectMeta;
        this.moduleMeta = moduleMeta;
    }

    private String getPackage() {
        return PackageHelper.getStructureObjectPackage(this.projectMeta.getGroupId(), this.projectMeta.getArtifactIdForPackage(), this.moduleMeta.getBoundContextName());
    }

    public ClassMeta to(AdlType type) {
        if (type == null) {
            return ClassMeta.to(Void.TYPE);
        }
        switch (Objects.requireNonNull(AdlNodeType.fromValue(type.getNodeType()))) {
            case VoidType: {
                return ClassMeta.to(Void.TYPE);
            }
            case StringType: {
                return ClassMeta.to(String.class);
            }
            case IntType: {
                return ClassMeta.to(Integer.class);
            }
            case DateType: {
                return ClassMeta.to(Date.class);
            }
            case ListType: {
                return ClassMeta.to(List.class);
            }
            case UserType: {
                AdlID name = type.getName();
                return ClassMeta.to(this.getPackage(), name.getText());
            }
        }
        return ClassMeta.to(Object.class);
    }
}

