/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.utils;

import com.alibaba.bizworks.codeinsight.utils.ModuleMeta;
import com.alibaba.bizworks.codeinsight.utils.ProjectMeta;
import java.io.File;

public class ProjectPathResolver {
    private ProjectMeta projectMeta;
    private ModuleMeta moduleMeta;

    public ProjectPathResolver(ProjectMeta projectMeta, ModuleMeta moduleMeta) {
        this.projectMeta = projectMeta;
        this.moduleMeta = moduleMeta;
    }

    private void getOrCreatePath(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public String getOrCreateApplicationInterfacePath() {
        String bdctx = this.moduleMeta.getBoundContextNameAsCode();
        String path = this.projectMeta.getProjectRootPath() + "/" + bdctx + "/" + bdctx + "-application/" + bdctx + "-service/src/main/java";
        this.getOrCreatePath(path);
        return path;
    }

    public String getOrCreateApplicationImplementationPath() {
        String bdctx = this.moduleMeta.getBoundContextNameAsCode();
        String path = this.projectMeta.getProjectRootPath() + "/" + bdctx + "/" + bdctx + "-application/" + bdctx + "-service-impl/src/main/java";
        this.getOrCreatePath(path);
        return path;
    }

    public String getOrCreateApplicationClientPath() {
        String bdctx = this.moduleMeta.getBoundContextNameAsCode();
        String path = this.projectMeta.getProjectRootPath() + "/" + bdctx + "/" + bdctx + "-interface/" + bdctx + "-client/src/main/java";
        this.getOrCreatePath(path);
        return path;
    }

    public String getOrCreateApplicationEntryPath() {
        String bdctx = this.moduleMeta.getBoundContextNameAsCode();
        String path = this.projectMeta.getProjectRootPath() + "/" + bdctx + "/" + bdctx + "-interface/" + bdctx + "-entry/src/main/java";
        this.getOrCreatePath(path);
        return path;
    }
}

