/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.codeinsight.utils;

import com.alibaba.bizworks.codeinsight.model.ComponentDescriptor;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class YamlUtils {
    public static void saveYaml(Object model, String path) {
        BwRepresenter representer = new BwRepresenter();
        representer.addClassTag(model.getClass(), Tag.MAP);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml((Representer)representer, options);
        try (FileWriter writer = new FileWriter(path);){
            yaml.dump(model, (Writer)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ComponentDescriptor loadComponentDescriptorYaml(String yamlFile) {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(ComponentDescriptor.class));
        try {
            return (ComponentDescriptor)yaml.loadAs((InputStream)new FileInputStream(yamlFile), ComponentDescriptor.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class BwRepresenter
    extends Representer {
        public BwRepresenter() {
            PropertyUtils propUtil = new PropertyUtils(){

                protected Set<Property> createPropertySet(Class<? extends Object> type, BeanAccess bAccess) {
                    return ((Stream)this.getPropertiesMap(type, BeanAccess.FIELD).values().stream().sequential()).filter(prop -> prop.isReadable() && (this.isAllowReadOnlyProperties() || prop.isWritable())).collect(Collectors.toCollection(LinkedHashSet::new));
                }
            };
            this.setPropertyUtils(propUtil);
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            return propertyValue == null ? null : super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }
    }
}

