/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.deployment.gateway;

import com.alibaba.bizworks.ide.domain.sync.framework.deployment.gateway.DeploymentGateway;
import com.alibaba.bizworks.ide.domain.sync.framework.deployment.model.BwDeploymentDetail;
import com.alibaba.bizworks.ide.domain.sync.framework.deployment.model.BwEnvironment;
import com.alibaba.bizworks.ide.domain.sync.framework.deployment.model.BwUpgradeDeploymentResult;
import com.alibaba.bizworks.ide.domain.sync.framework.deployment.model.GetDeploymentDetailReq;
import com.alibaba.bizworks.ide.domain.sync.framework.deployment.model.GetRecordReq;
import com.alibaba.bizworks.ide.domain.sync.framework.deployment.model.UpgradeDeploymentReq;
import com.alibaba.bizworks.sync.infra.deployment.client.DeploymentClient;
import com.alibaba.bizworks.sync.infra.deployment.converter.BwDeploymentConverter;
import com.alibaba.bizworks.sync.infra.deployment.converter.BwEnvironmentConverter;
import com.alibaba.bizworks.sync.infra.deployment.converter.BwUpgradeDeploymentConverter;
import com.alibaba.bizworks.sync.infra.deployment.dto.DeploymentDetailDTO;
import com.alibaba.bizworks.sync.infra.deployment.dto.ListBranchesReq;
import com.alibaba.bizworks.sync.infra.deployment.dto.ListEnvironmentReq;
import com.alibaba.bizworks.sync.infra.deployment.dto.UpgradeDeploymentResultDTO;
import com.alibaba.bizworks.sync.infra.http.ClientManager;
import com.alibaba.bizworks.sync.infra.http.ClientUtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0016JN\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u001dH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/alibaba/bizworks/sync/infra/deployment/gateway/DeploymentGatewayImpl;", "Lcom/alibaba/bizworks/ide/domain/sync/framework/deployment/gateway/DeploymentGateway;", "clientManager", "Lcom/alibaba/bizworks/sync/infra/http/ClientManager;", "(Lcom/alibaba/bizworks/sync/infra/http/ClientManager;)V", "deploymentClient", "Lcom/alibaba/bizworks/sync/infra/deployment/client/DeploymentClient;", "getDeploymentIDEDetail", "Lcom/alibaba/bizworks/ide/domain/sync/framework/deployment/model/BwDeploymentDetail;", "req", "Lcom/alibaba/bizworks/ide/domain/sync/framework/deployment/model/GetDeploymentDetailReq;", "getDeploymentRecordByCode", "Lcom/alibaba/bizworks/ide/domain/sync/framework/deployment/model/BwUpgradeDeploymentResult;", "Lcom/alibaba/bizworks/ide/domain/sync/framework/deployment/model/GetRecordReq;", "listBranches", "", "", "projectCode", "applicationCode", "listEnvironments", "", "Lcom/alibaba/bizworks/ide/domain/sync/framework/deployment/model/BwEnvironment;", "order", "orderBy", "groupBy", "pageNum", "", "pageSize", "upgradeIDEDeployment", "Lcom/alibaba/bizworks/ide/domain/sync/framework/deployment/model/UpgradeDeploymentReq;", "toolkit-infra"})
public class DeploymentGatewayImpl
implements DeploymentGateway {
    @NotNull
    private final DeploymentClient deploymentClient;

    public DeploymentGatewayImpl(@NotNull ClientManager clientManager) {
        Intrinsics.checkNotNullParameter((Object)clientManager, (String)"clientManager");
        this.deploymentClient = clientManager.getClient(DeploymentClient.class);
    }

    @Nullable
    public List<BwEnvironment> listEnvironments(@NotNull String applicationCode, @NotNull String projectCode, @NotNull String order, @NotNull List<String> orderBy, @NotNull String groupBy, int pageNum, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)applicationCode, (String)"applicationCode");
        Intrinsics.checkNotNullParameter((Object)projectCode, (String)"projectCode");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        Intrinsics.checkNotNullParameter(orderBy, (String)"orderBy");
        Intrinsics.checkNotNullParameter((Object)groupBy, (String)"groupBy");
        ListEnvironmentReq req = new ListEnvironmentReq(pageNum, pageSize, projectCode, order, orderBy, groupBy, applicationCode);
        Collection get2 = ClientUtilsKt.get(this.deploymentClient.listEnvironments(req)).getData().getItems();
        return BwEnvironmentConverter.INSTANCE.toBwList(get2);
    }

    @Nullable
    public BwDeploymentDetail getDeploymentIDEDetail(@NotNull GetDeploymentDetailReq req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        DeploymentDetailDTO deploymentDetailDTO = (DeploymentDetailDTO)ClientUtilsKt.get(this.deploymentClient.getDeploymentIDEDetail(req)).getData();
        if (deploymentDetailDTO == null) {
            return null;
        }
        DeploymentDetailDTO data = deploymentDetailDTO;
        return BwDeploymentConverter.INSTANCE.toBw(data);
    }

    @NotNull
    public BwUpgradeDeploymentResult upgradeIDEDeployment(@NotNull UpgradeDeploymentReq req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        UpgradeDeploymentResultDTO data = (UpgradeDeploymentResultDTO)ClientUtilsKt.get(this.deploymentClient.upgradeIDEDeployment(req)).getData();
        BwUpgradeDeploymentResult bwUpgradeDeploymentResult = BwUpgradeDeploymentConverter.INSTANCE.toBw(data);
        Intrinsics.checkNotNullExpressionValue((Object)bwUpgradeDeploymentResult, (String)"toBw(...)");
        return bwUpgradeDeploymentResult;
    }

    @NotNull
    public Collection<String> listBranches(@Nullable String projectCode, @Nullable String applicationCode) {
        ListBranchesReq listBranchesReq = new ListBranchesReq(projectCode, applicationCode);
        Collection collection = ClientUtilsKt.get(this.deploymentClient.listBranches(listBranchesReq)).getData().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getItems(...)");
        return collection;
    }

    @NotNull
    public BwUpgradeDeploymentResult getDeploymentRecordByCode(@NotNull GetRecordReq req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        UpgradeDeploymentResultDTO data = (UpgradeDeploymentResultDTO)ClientUtilsKt.get(this.deploymentClient.getDeploymentRecordByCode(req)).getData();
        BwUpgradeDeploymentResult bwUpgradeDeploymentResult = BwUpgradeDeploymentConverter.INSTANCE.toBw(data);
        Intrinsics.checkNotNullExpressionValue((Object)bwUpgradeDeploymentResult, (String)"toBw(...)");
        return bwUpgradeDeploymentResult;
    }
}

