/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.http;

import com.alibaba.bizworks.ide.domain.sync.framework.config.GlobalConfigManager;
import com.alibaba.bizworks.sync.infra.http.AllOkTrustManager;
import com.alibaba.bizworks.sync.infra.http.BizAuthInterceptor;
import com.alibaba.bizworks.sync.infra.http.BizProxySelector;
import com.alibaba.bizworks.sync.infra.http.BizUrlInterceptor;
import com.alibaba.bizworks.sync.infra.http.ClientManager;
import com.alibaba.bizworks.sync.infra.http.ClientManagerImpl;
import com.alibaba.bizworks.sync.infra.http.CustomHttpLoggingInterceptor;
import com.alibaba.bizworks.sync.infra.http.HttpProxyInterceptor;
import com.alibaba.bizworks.sync.infra.stats.client.ActionStatsClient;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.ProxySelector;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0006\u0010\f\u001a\u00020\rJ!\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0006H\u0002J\b\u0010\u0014\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/alibaba/bizworks/sync/infra/http/ClientManagerImpl;", "Lcom/alibaba/bizworks/sync/infra/http/ClientManager;", "configManager", "Lcom/alibaba/bizworks/ide/domain/sync/framework/config/GlobalConfigManager;", "(Lcom/alibaba/bizworks/ide/domain/sync/framework/config/GlobalConfigManager;)V", "underOkHttpClient", "Lokhttp3/OkHttpClient;", "underRetrofit", "Lretrofit2/Retrofit;", "createOkHttpClient", "createRetrofit", "okHttpClient", "createStatsClient", "Lcom/alibaba/bizworks/sync/infra/stats/client/ActionStatsClient;", "getClient", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getOkHttpClient", "getRetrofit", "toolkit-infra"})
public class ClientManagerImpl
implements ClientManager {
    @NotNull
    private final GlobalConfigManager configManager;
    @Nullable
    private volatile OkHttpClient underOkHttpClient;
    @Nullable
    private volatile Retrofit underRetrofit;

    public ClientManagerImpl(@NotNull GlobalConfigManager configManager) {
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
        this.configManager = configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final OkHttpClient getOkHttpClient() {
        if (this.underOkHttpClient == null) {
            ClientManagerImpl clientManagerImpl = this;
            synchronized (clientManagerImpl) {
                boolean bl = false;
                if (this.underOkHttpClient == null) {
                    this.underOkHttpClient = this.createOkHttpClient(this.configManager);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        OkHttpClient okHttpClient = this.underOkHttpClient;
        Intrinsics.checkNotNull((Object)okHttpClient);
        return okHttpClient;
    }

    private final OkHttpClient createOkHttpClient(GlobalConfigManager configManager) {
        SSLContext sSLContext;
        SSLContext it = sSLContext = SSLContext.getInstance("SSL");
        boolean bl = false;
        Object[] objectArray = new TrustManager[]{AllOkTrustManager.INSTANCE};
        it.init(null, (TrustManager[])objectArray, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sSLContext.getSocketFactory();
        CustomHttpLoggingInterceptor loggingInterceptor = new CustomHttpLoggingInterceptor(null, 1, null);
        loggingInterceptor.redactHeader("Proxy-Authorization");
        BizProxySelector bizProxySelector = new BizProxySelector(configManager);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Intrinsics.checkNotNull((Object)sslSocketFactory);
        OkHttpClient.Builder builder2 = builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)AllOkTrustManager.INSTANCE).hostnameVerifier(ClientManagerImpl::createOkHttpClient$lambda$2).addInterceptor((Interceptor)new BizUrlInterceptor((Function0<String>)((Function0)new Function0<String>(configManager){
            final /* synthetic */ GlobalConfigManager $configManager;
            {
                this.$configManager = $configManager;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = this.$configManager.needValidApiConfig().getServerUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getServerUrl(...)");
                return string;
            }
        }))).addInterceptor((Interceptor)new BizAuthInterceptor(configManager)).addInterceptor((Interceptor)new HttpProxyInterceptor(configManager)).addInterceptor((Interceptor)loggingInterceptor).pingInterval(5L, TimeUnit.SECONDS);
        Duration duration = Duration.ofSeconds(120L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        objectArray = new ConnectionSpec[]{ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT};
        builder2.readTimeout(duration).retryOnConnectionFailure(true).proxySelector((ProxySelector)bizProxySelector).protocols(CollectionsKt.listOf((Object)Protocol.HTTP_1_1)).connectionSpecs(Util.immutableListOf((Object[])objectArray));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Retrofit getRetrofit() {
        if (this.underRetrofit == null) {
            ClientManagerImpl clientManagerImpl = this;
            synchronized (clientManagerImpl) {
                boolean bl = false;
                if (this.underRetrofit == null) {
                    this.underRetrofit = this.createRetrofit(this.getOkHttpClient());
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        Retrofit retrofit = this.underRetrofit;
        Intrinsics.checkNotNull((Object)retrofit);
        return retrofit;
    }

    private final Retrofit createRetrofit(OkHttpClient okHttpClient) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl("https://bizworks.aliyun.com/").addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        return retrofit;
    }

    @NotNull
    public final ActionStatsClient createStatsClient() {
        OkHttpClient.Builder clientBuilder = this.getOkHttpClient().newBuilder();
        List interceptors = clientBuilder.interceptors();
        interceptors.removeIf(arg_0 -> ClientManagerImpl.createStatsClient$lambda$4(createStatsClient.1.INSTANCE, arg_0));
        interceptors.add(0, new BizUrlInterceptor((Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ ClientManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = ClientManagerImpl.access$getConfigManager$p(this.this$0).needValidApiConfig().getServerUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getServerUrl(...)");
                return string;
            }
        })));
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        clientBuilder.readTimeout(duration);
        Retrofit retrofit = this.getRetrofit().newBuilder().client(clientBuilder.build()).build();
        Object object = retrofit.create(ActionStatsClient.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        return (ActionStatsClient)object;
    }

    @Override
    public <T> T getClient(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)this.getRetrofit().create(clazz);
    }

    private static final boolean createOkHttpClient$lambda$2(String string, SSLSession sSLSession) {
        return true;
    }

    private static final boolean createStatsClient$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ GlobalConfigManager access$getConfigManager$p(ClientManagerImpl $this) {
        return $this.configManager;
    }
}

