/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdField;
import com.alibaba.bizworks.ads.meta.lang.element.MdOperation;
import com.alibaba.bizworks.ads.meta.lang.file.MdApplicationService;
import com.alibaba.bizworks.sync.infra.meta.converter.ApplicationServiceDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.FieldDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OperationDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OriginTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.ApplicationServiceDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.FieldDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.OperationDTO;
import java.util.ArrayList;
import java.util.List;

public class ApplicationServiceDtoConverterImpl
implements ApplicationServiceDtoConverter {
    private final FieldDtoConverter fieldDtoConverter = FieldDtoConverter.INSTANCE;
    private final OperationDtoConverter operationDtoConverter = OperationDtoConverter.INSTANCE;
    private final ModuleDtoConverter moduleDtoConverter = ModuleDtoConverter.INSTANCE;
    private final OriginTypeConverter originTypeConverter = OriginTypeConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public ApplicationServiceDTO toDto(MdApplicationService md) {
        if (md == null) {
            return null;
        }
        ApplicationServiceDTO applicationServiceDTO = new ApplicationServiceDTO();
        applicationServiceDTO.setLabel(md.getPresentableText());
        applicationServiceDTO.setRealName(md.getCodeName());
        applicationServiceDTO.setName(md.getName());
        applicationServiceDTO.setDisplayName(md.getDisplayName());
        applicationServiceDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        applicationServiceDTO.setOrigin(this.originTypeConverter.toStr(md.getOrigin()));
        if (md.getPlatformReadOnly() != null) {
            applicationServiceDTO.setPlatformReadOnly(String.valueOf(md.getPlatformReadOnly()));
        }
        applicationServiceDTO.setDescription(md.getDescription());
        applicationServiceDTO.setNamespace(md.getNamespace());
        applicationServiceDTO.setUuid(md.getUuid());
        applicationServiceDTO.setFields(this.mdFieldListToFieldDTOList(md.getFields()));
        applicationServiceDTO.setOperations(this.mdOperationListToOperationDTOList(md.getOperations()));
        applicationServiceDTO.setCommitId(md.getCommitId());
        applicationServiceDTO.setModule(this.moduleDtoConverter.toDto(md.getModule()));
        applicationServiceDTO.setKind(md.getKind());
        return applicationServiceDTO;
    }

    @Override
    public MdApplicationService toMd(ApplicationServiceDTO dto) {
        if (dto == null) {
            return null;
        }
        MdApplicationService mdApplicationService = new MdApplicationService();
        mdApplicationService.setPresentableText(dto.getLabel());
        mdApplicationService.setCodeName(dto.getRealName());
        mdApplicationService.setName(dto.getName());
        mdApplicationService.setDisplayName(dto.getDisplayName());
        mdApplicationService.setDescription(dto.getDescription());
        mdApplicationService.setNamespace(dto.getNamespace());
        mdApplicationService.setUuid(dto.getUuid());
        mdApplicationService.setFields(this.fieldDTOListToMdFieldList(dto.getFields()));
        mdApplicationService.setCommitId(dto.getCommitId());
        mdApplicationService.setModule(this.moduleDtoConverter.toMd(dto.getModule()));
        mdApplicationService.setOrigin(this.originTypeConverter.toEnum(dto.getOrigin()));
        if (dto.getPlatformReadOnly() != null) {
            mdApplicationService.setPlatformReadOnly(Boolean.valueOf(Boolean.parseBoolean(dto.getPlatformReadOnly())));
        }
        mdApplicationService.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdApplicationService.setOperations(this.operationDTOListToMdOperationList(dto.getOperations()));
        return mdApplicationService;
    }

    protected List<FieldDTO> mdFieldListToFieldDTOList(List<MdField> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FieldDTO> list1 = new ArrayList<FieldDTO>(list.size());
        for (MdField mdField : list) {
            list1.add(this.fieldDtoConverter.toDto(mdField));
        }
        return list1;
    }

    protected List<OperationDTO> mdOperationListToOperationDTOList(List<MdOperation> list) {
        if (list == null) {
            return null;
        }
        ArrayList<OperationDTO> list1 = new ArrayList<OperationDTO>(list.size());
        for (MdOperation mdOperation : list) {
            list1.add(this.operationDtoConverter.toDto(mdOperation));
        }
        return list1;
    }

    protected List<MdField> fieldDTOListToMdFieldList(List<FieldDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdField> list1 = new ArrayList<MdField>(list.size());
        for (FieldDTO fieldDTO : list) {
            list1.add(this.fieldDtoConverter.toMd(fieldDTO));
        }
        return list1;
    }

    protected List<MdOperation> operationDTOListToMdOperationList(List<OperationDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdOperation> list1 = new ArrayList<MdOperation>(list.size());
        for (OperationDTO operationDTO : list) {
            list1.add(this.operationDtoConverter.toMd(operationDTO));
        }
        return list1;
    }
}

