/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdField;
import com.alibaba.bizworks.ads.meta.lang.file.MdCustomObject;
import com.alibaba.bizworks.ads.meta.lang.file.OriginType;
import com.alibaba.bizworks.sync.infra.meta.converter.CodeInformationConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.CustomObjectDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.FieldDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.CustomObjectDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.FieldDTO;
import java.util.ArrayList;
import java.util.List;

public class CustomObjectDtoConverterImpl
implements CustomObjectDtoConverter {
    private final FieldDtoConverter fieldDtoConverter = FieldDtoConverter.INSTANCE;
    private final ModuleDtoConverter moduleDtoConverter = ModuleDtoConverter.INSTANCE;
    private final CodeInformationConverter codeInformationConverter = CodeInformationConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public CustomObjectDTO toDto(MdCustomObject md) {
        if (md == null) {
            return null;
        }
        CustomObjectDTO customObjectDTO = new CustomObjectDTO();
        customObjectDTO.set_package(md.getPkg());
        customObjectDTO.setLabel(md.getPresentableText());
        customObjectDTO.setName(md.getName());
        customObjectDTO.setDisplayName(md.getDisplayName());
        customObjectDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        if (md.getOrigin() != null) {
            customObjectDTO.setOrigin(md.getOrigin().name());
        }
        if (md.getPlatformReadOnly() != null) {
            customObjectDTO.setPlatformReadOnly(String.valueOf(md.getPlatformReadOnly()));
        }
        customObjectDTO.setDescription(md.getDescription());
        customObjectDTO.setNamespace(md.getNamespace());
        customObjectDTO.setUuid(md.getUuid());
        customObjectDTO.setFields(this.mdFieldListToFieldDTOList(md.getFields()));
        customObjectDTO.setCommitId(md.getCommitId());
        customObjectDTO.setModule(this.moduleDtoConverter.toDto(md.getModule()));
        customObjectDTO.setSimpleName(md.getSimpleName());
        customObjectDTO.setGenericsText(md.getGenericsText());
        customObjectDTO.setAdditionalInformation(md.getAdditionalInformation());
        customObjectDTO.setCodeInformation(this.codeInformationConverter.toStr(md.getCodeInformation()));
        return customObjectDTO;
    }

    @Override
    public MdCustomObject toMd(CustomObjectDTO dto) {
        if (dto == null) {
            return null;
        }
        MdCustomObject mdCustomObject = new MdCustomObject();
        mdCustomObject.setPkg(dto.get_package());
        mdCustomObject.setPresentableText(dto.getLabel());
        mdCustomObject.setName(dto.getName());
        mdCustomObject.setDisplayName(dto.getDisplayName());
        mdCustomObject.setDescription(dto.getDescription());
        mdCustomObject.setNamespace(dto.getNamespace());
        mdCustomObject.setUuid(dto.getUuid());
        mdCustomObject.setFields(this.fieldDTOListToMdFieldList(dto.getFields()));
        mdCustomObject.setCommitId(dto.getCommitId());
        mdCustomObject.setModule(this.moduleDtoConverter.toMd(dto.getModule()));
        if (dto.getOrigin() != null) {
            mdCustomObject.setOrigin(Enum.valueOf(OriginType.class, dto.getOrigin()));
        }
        if (dto.getPlatformReadOnly() != null) {
            mdCustomObject.setPlatformReadOnly(Boolean.valueOf(Boolean.parseBoolean(dto.getPlatformReadOnly())));
        }
        mdCustomObject.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdCustomObject.setCodeInformation(this.codeInformationConverter.toMd(dto.getCodeInformation()));
        mdCustomObject.setSimpleName(dto.getSimpleName());
        mdCustomObject.setGenericsText(dto.getGenericsText());
        mdCustomObject.setAdditionalInformation(dto.getAdditionalInformation());
        return mdCustomObject;
    }

    protected List<FieldDTO> mdFieldListToFieldDTOList(List<MdField> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FieldDTO> list1 = new ArrayList<FieldDTO>(list.size());
        for (MdField mdField : list) {
            list1.add(this.fieldDtoConverter.toDto(mdField));
        }
        return list1;
    }

    protected List<MdField> fieldDTOListToMdFieldList(List<FieldDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdField> list1 = new ArrayList<MdField>(list.size());
        for (FieldDTO fieldDTO : list) {
            list1.add(this.fieldDtoConverter.toMd(fieldDTO));
        }
        return list1;
    }
}

