/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdField;
import com.alibaba.bizworks.ads.meta.lang.file.MdDomainEvent;
import com.alibaba.bizworks.sync.infra.meta.converter.DomainEventDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.FieldDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.OriginTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.DomainEventDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.FieldDTO;
import java.util.ArrayList;
import java.util.List;

public class DomainEventDtoConverterImpl
implements DomainEventDtoConverter {
    private final FieldDtoConverter fieldDtoConverter = FieldDtoConverter.INSTANCE;
    private final ModuleDtoConverter moduleDtoConverter = ModuleDtoConverter.INSTANCE;
    private final OriginTypeConverter originTypeConverter = OriginTypeConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public DomainEventDTO toDto(MdDomainEvent md) {
        if (md == null) {
            return null;
        }
        DomainEventDTO domainEventDTO = new DomainEventDTO();
        domainEventDTO.setRealName(md.getCodeName());
        domainEventDTO.setLabel(md.getPresentableText());
        domainEventDTO.setName(md.getName());
        domainEventDTO.setDisplayName(md.getDisplayName());
        domainEventDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        domainEventDTO.setOrigin(this.originTypeConverter.toStr(md.getOrigin()));
        if (md.getPlatformReadOnly() != null) {
            domainEventDTO.setPlatformReadOnly(String.valueOf(md.getPlatformReadOnly()));
        }
        domainEventDTO.setDescription(md.getDescription());
        domainEventDTO.setNamespace(md.getNamespace());
        domainEventDTO.setUuid(md.getUuid());
        domainEventDTO.setCommitId(md.getCommitId());
        domainEventDTO.setModule(this.moduleDtoConverter.toDto(md.getModule()));
        domainEventDTO.setKind(md.getKind());
        domainEventDTO.setFields(this.mdFieldListToFieldDTOList(md.getFields()));
        return domainEventDTO;
    }

    @Override
    public MdDomainEvent toMd(DomainEventDTO dto) {
        if (dto == null) {
            return null;
        }
        MdDomainEvent mdDomainEvent = new MdDomainEvent();
        mdDomainEvent.setPresentableText(dto.getLabel());
        mdDomainEvent.setCodeName(dto.getRealName());
        mdDomainEvent.setName(dto.getName());
        mdDomainEvent.setDisplayName(dto.getDisplayName());
        mdDomainEvent.setDescription(dto.getDescription());
        mdDomainEvent.setNamespace(dto.getNamespace());
        mdDomainEvent.setUuid(dto.getUuid());
        mdDomainEvent.setFields(this.fieldDTOListToMdFieldList(dto.getFields()));
        mdDomainEvent.setCommitId(dto.getCommitId());
        mdDomainEvent.setModule(this.moduleDtoConverter.toMd(dto.getModule()));
        mdDomainEvent.setOrigin(this.originTypeConverter.toEnum(dto.getOrigin()));
        if (dto.getPlatformReadOnly() != null) {
            mdDomainEvent.setPlatformReadOnly(Boolean.valueOf(Boolean.parseBoolean(dto.getPlatformReadOnly())));
        }
        mdDomainEvent.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        return mdDomainEvent;
    }

    protected List<FieldDTO> mdFieldListToFieldDTOList(List<MdField> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FieldDTO> list1 = new ArrayList<FieldDTO>(list.size());
        for (MdField mdField : list) {
            list1.add(this.fieldDtoConverter.toDto(mdField));
        }
        return list1;
    }

    protected List<MdField> fieldDTOListToMdFieldList(List<FieldDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdField> list1 = new ArrayList<MdField>(list.size());
        for (FieldDTO fieldDTO : list) {
            list1.add(this.fieldDtoConverter.toMd(fieldDTO));
        }
        return list1;
    }
}

