/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdDataField;
import com.alibaba.bizworks.ads.meta.lang.element.MdField;
import com.alibaba.bizworks.sync.infra.meta.converter.FieldDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.TypeInfoDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.DataFieldDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.DataType;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.FieldDTO;

public class FieldDtoConverterImpl
implements FieldDtoConverter {
    private final TypeInfoDtoConverter typeInfoDtoConverter = TypeInfoDtoConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public FieldDTO toDto(MdField md) {
        if (md == null) {
            return null;
        }
        FieldDTO fieldDTO = new FieldDTO();
        fieldDTO.setRealName(md.getCodeName());
        fieldDTO.setName(md.getName());
        fieldDTO.setDisplayName(md.getDisplayName());
        fieldDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        fieldDTO.setKind(md.getKind());
        fieldDTO.setDescription(md.getDescription());
        fieldDTO.setUuid(md.getUuid());
        fieldDTO.setInherited(md.getInherited());
        fieldDTO.setRequired(md.isRequired());
        fieldDTO.setTypeInfo(this.typeInfoDtoConverter.toDto(md.getTypeInfo()));
        return fieldDTO;
    }

    @Override
    public MdField toMd(FieldDTO dto) {
        if (dto == null) {
            return null;
        }
        MdField mdField = new MdField();
        mdField.setCodeName(dto.getRealName());
        mdField.setName(dto.getName());
        mdField.setDisplayName(dto.getDisplayName());
        mdField.setDescription(dto.getDescription());
        mdField.setUuid(dto.getUuid());
        mdField.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdField.setInherited(dto.getInherited());
        mdField.setTypeInfo(this.typeInfoDtoConverter.toMd(dto.getTypeInfo()));
        mdField.setRequired(dto.isRequired());
        return mdField;
    }

    @Override
    public DataFieldDTO toDto(MdDataField md) {
        if (md == null) {
            return null;
        }
        DataFieldDTO dataFieldDTO = new DataFieldDTO();
        dataFieldDTO.setRealName(md.getCodeName());
        dataFieldDTO.setName(md.getName());
        dataFieldDTO.setDisplayName(md.getDisplayName());
        dataFieldDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        dataFieldDTO.setKind(md.getKind());
        dataFieldDTO.setDescription(md.getDescription());
        dataFieldDTO.setUuid(md.getUuid());
        dataFieldDTO.setInherited(md.getInherited());
        dataFieldDTO.setRequired(md.isRequired());
        dataFieldDTO.setMarshalName(md.getMarshalName());
        dataFieldDTO.setReserved(md.getReserved());
        dataFieldDTO.setUnique(md.getUnique());
        dataFieldDTO.setMultiValue(md.getMultiValue());
        dataFieldDTO.setDefaultValue(md.getDefaultValue());
        dataFieldDTO.setMaxLength(md.getMaxLength());
        dataFieldDTO.setMinLength(md.getMinLength());
        dataFieldDTO.setSize(md.getSize());
        dataFieldDTO.setPrecision(md.getPrecision());
        dataFieldDTO.setScale(md.getScale());
        dataFieldDTO.setSequence(md.getSequence());
        dataFieldDTO.setType(md.getTypeInfo() != null ? DataType.dataTypeOf(md.getTypeInfo().getType()).getCode() : null);
        return dataFieldDTO;
    }

    @Override
    public MdDataField toMd(DataFieldDTO dto) {
        if (dto == null) {
            return null;
        }
        MdDataField mdDataField = new MdDataField();
        mdDataField.setCodeName(dto.getRealName());
        mdDataField.setTypeInfo(this.typeInfoDtoConverter.toMd(dto.getType()));
        mdDataField.setName(dto.getName());
        mdDataField.setDisplayName(dto.getDisplayName());
        mdDataField.setDescription(dto.getDescription());
        mdDataField.setUuid(dto.getUuid());
        mdDataField.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdDataField.setInherited(dto.getInherited());
        mdDataField.setRequired(dto.isRequired());
        mdDataField.setMarshalName(dto.getMarshalName());
        mdDataField.setReserved(dto.getReserved());
        mdDataField.setUnique(dto.getUnique());
        mdDataField.setMultiValue(dto.getMultiValue());
        mdDataField.setDefaultValue(dto.getDefaultValue());
        mdDataField.setMaxLength(dto.getMaxLength());
        mdDataField.setMinLength(dto.getMinLength());
        mdDataField.setSize(dto.getSize());
        mdDataField.setPrecision(dto.getPrecision());
        mdDataField.setScale(dto.getScale());
        mdDataField.setSequence(dto.getSequence());
        return mdDataField;
    }
}

