/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter;

import com.alibaba.bizworks.ads.meta.lang.element.MdRelationship;
import com.alibaba.bizworks.ads.meta.lang.element.RelationshipFieldMapping;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.MultiplicityConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.ReferenceDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.RelationshipDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.RelationshipTypeConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.RelationshipDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.meta.RelationshipFieldMappingDTO;
import java.util.ArrayList;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class RelationshipDtoConverterImpl
implements RelationshipDtoConverter {
    private final ReferenceDtoConverter referenceDtoConverter = ReferenceDtoConverter.INSTANCE;
    private final RelationshipTypeConverter relationshipTypeConverter = (RelationshipTypeConverter)Mappers.getMapper(RelationshipTypeConverter.class);
    private final MultiplicityConverter multiplicityConverter = (MultiplicityConverter)Mappers.getMapper(MultiplicityConverter.class);
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public RelationshipDTO toDto(MdRelationship md) {
        if (md == null) {
            return null;
        }
        RelationshipDTO relationshipDTO = new RelationshipDTO();
        relationshipDTO.setRealName(md.getCodeName());
        relationshipDTO.setName(md.getName());
        relationshipDTO.setDisplayName(md.getDisplayName());
        relationshipDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        relationshipDTO.setKind(md.getKind());
        relationshipDTO.setDescription(md.getDescription());
        relationshipDTO.setUuid(md.getUuid());
        relationshipDTO.setRelatedObject(this.referenceDtoConverter.toDto(md.getRelatedObject()));
        relationshipDTO.setType(this.relationshipTypeConverter.toStr(md.getType()));
        relationshipDTO.setMultiplicity(this.multiplicityConverter.toStr(md.getMultiplicity()));
        List list = md.getFieldMappings();
        if (list != null) {
            relationshipDTO.setFieldMappings(new ArrayList<RelationshipFieldMapping>(list));
        }
        return relationshipDTO;
    }

    @Override
    public MdRelationship toMd(RelationshipDTO dto) {
        if (dto == null) {
            return null;
        }
        MdRelationship mdRelationship = new MdRelationship();
        mdRelationship.setCodeName(dto.getRealName());
        mdRelationship.setName(dto.getName());
        mdRelationship.setDisplayName(dto.getDisplayName());
        mdRelationship.setDescription(dto.getDescription());
        mdRelationship.setUuid(dto.getUuid());
        mdRelationship.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        mdRelationship.setRelatedObject(this.referenceDtoConverter.toMd(dto.getRelatedObject()));
        mdRelationship.setType(this.relationshipTypeConverter.toEnum(dto.getType()));
        mdRelationship.setMultiplicity(this.multiplicityConverter.toEnum(dto.getMultiplicity()));
        List<RelationshipFieldMapping> list = dto.getFieldMappings();
        if (list != null) {
            mdRelationship.setFieldMappings(new ArrayList<RelationshipFieldMapping>(list));
        }
        return mdRelationship;
    }

    @Override
    public RelationshipFieldMapping toMd(RelationshipFieldMappingDTO dto) {
        if (dto == null) {
            return null;
        }
        RelationshipFieldMapping relationshipFieldMapping = new RelationshipFieldMapping();
        relationshipFieldMapping.setFieldName(dto.getFieldName());
        relationshipFieldMapping.setRelatedFieldName(dto.getRelatedFieldName());
        return relationshipFieldMapping;
    }

    @Override
    public RelationshipFieldMappingDTO toDto(RelationshipFieldMapping dto) {
        if (dto == null) {
            return null;
        }
        RelationshipFieldMappingDTO relationshipFieldMappingDTO = new RelationshipFieldMappingDTO();
        relationshipFieldMappingDTO.setFieldName(dto.getFieldName());
        relationshipFieldMappingDTO.setRelatedFieldName(dto.getRelatedFieldName());
        return relationshipFieldMappingDTO;
    }
}

