/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.meta.converter.api;

import com.alibaba.bizworks.ads.meta.lang.element.MdInput;
import com.alibaba.bizworks.ads.meta.lang.element.MdOperation;
import com.alibaba.bizworks.sync.infra.meta.converter.MetadataExtInfoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.api.ApiInputDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.api.ApiMethodDTOConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.api.ApiOutputDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.converter.api.ApiReferenceDtoConverter;
import com.alibaba.bizworks.sync.infra.meta.dto.apimeta.MethodDTO;
import com.alibaba.bizworks.sync.infra.meta.dto.apimeta.MethodInputDTO;
import java.util.ArrayList;
import java.util.List;

public class ApiMethodDTOConverterImpl
implements ApiMethodDTOConverter {
    private final ApiReferenceDtoConverter apiReferenceDtoConverter = ApiReferenceDtoConverter.INSTANCE;
    private final ApiInputDtoConverter apiInputDtoConverter = ApiInputDtoConverter.INSTANCE;
    private final ApiOutputDtoConverter apiOutputDtoConverter = ApiOutputDtoConverter.INSTANCE;
    private final MetadataExtInfoConverter metadataExtInfoConverter = MetadataExtInfoConverter.INSTANCE;

    @Override
    public MethodDTO toDto(MdOperation md) {
        if (md == null) {
            return null;
        }
        MethodDTO methodDTO = new MethodDTO();
        methodDTO.setExtensionPointRefList(this.apiReferenceDtoConverter.toDtoList(md.getExtensionPointRefs()));
        methodDTO.setMethodOutputDTO(this.apiOutputDtoConverter.toDto(md.getOutput()));
        methodDTO.setMethodInputDTOList(this.apiInputDtoConverter.toDtoList(md.getInputs()));
        methodDTO.setName(md.getName());
        methodDTO.setDisplayName(md.getDisplayName());
        methodDTO.setDescription(md.getDescription());
        methodDTO.setExt(this.metadataExtInfoConverter.toStr(md.getExt()));
        return methodDTO;
    }

    @Override
    public MdOperation toMd(MethodDTO dto) {
        if (dto == null) {
            return null;
        }
        MdOperation mdOperation = new MdOperation();
        mdOperation.setExtensionPointRefs(this.apiReferenceDtoConverter.toMdList(dto.getExtensionPointRefList()));
        mdOperation.setOutput(this.apiOutputDtoConverter.toMd(dto.getMethodOutputDTO()));
        mdOperation.setInputs(this.methodInputDTOListToMdInputList(dto.getMethodInputDTOList()));
        mdOperation.setName(dto.getName());
        mdOperation.setDisplayName(dto.getDisplayName());
        mdOperation.setDescription(dto.getDescription());
        mdOperation.setExt(this.metadataExtInfoConverter.toMd(dto.getExt()));
        return mdOperation;
    }

    protected MdInput methodInputDTOToMdInput(MethodInputDTO methodInputDTO) {
        if (methodInputDTO == null) {
            return null;
        }
        MdInput mdInput = new MdInput();
        mdInput.setName(methodInputDTO.getName());
        mdInput.setDisplayName(methodInputDTO.getDisplayName());
        mdInput.setDescription(methodInputDTO.getDescription());
        mdInput.setExt(this.metadataExtInfoConverter.toMd(methodInputDTO.getExt()));
        return mdInput;
    }

    protected List<MdInput> methodInputDTOListToMdInputList(List<MethodInputDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MdInput> list1 = new ArrayList<MdInput>(list.size());
        for (MethodInputDTO methodInputDTO : list) {
            list1.add(this.methodInputDTOToMdInput(methodInputDTO));
        }
        return list1;
    }
}

