/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.sync.infra.module.converter;

import com.alibaba.bizworks.ide.domain.module.ModuleVersion;
import com.alibaba.bizworks.sync.infra.app.dto.AppVersionOnlyDTO;
import com.alibaba.bizworks.sync.infra.app.dto.AppVersionWrapperDTO;
import com.alibaba.bizworks.sync.infra.meta.converter.ModuleVersionStatusConverter;
import com.alibaba.bizworks.sync.infra.module.converter.ModuleVersionConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class ModuleVersionConverterImpl
implements ModuleVersionConverter {
    private final ModuleVersionStatusConverter moduleVersionStatusConverter = (ModuleVersionStatusConverter)Mappers.getMapper(ModuleVersionStatusConverter.class);

    @Override
    public ModuleVersion toMd(AppVersionWrapperDTO source) {
        if (source == null) {
            return null;
        }
        ModuleVersion moduleVersion = new ModuleVersion();
        moduleVersion.setProjectCode(source.getProjectCode());
        moduleVersion.setStatus(this.moduleVersionStatusConverter.toEnum(this.sourceVersionStatus(source)));
        moduleVersion.setVersion(this.sourceVersionNumber(source));
        moduleVersion.setSourceVersion(source.getSourceVersion());
        return moduleVersion;
    }

    @Override
    public List<ModuleVersion> toMdList(Collection<AppVersionWrapperDTO> source) {
        if (source == null) {
            return null;
        }
        ArrayList<ModuleVersion> list = new ArrayList<ModuleVersion>(source.size());
        for (AppVersionWrapperDTO appVersionWrapperDTO : source) {
            list.add(this.toMd(appVersionWrapperDTO));
        }
        return list;
    }

    private String sourceVersionStatus(AppVersionWrapperDTO appVersionWrapperDTO) {
        if (appVersionWrapperDTO == null) {
            return null;
        }
        AppVersionOnlyDTO version = appVersionWrapperDTO.getVersion();
        if (version == null) {
            return null;
        }
        String status = version.getStatus();
        if (status == null) {
            return null;
        }
        return status;
    }

    private String sourceVersionNumber(AppVersionWrapperDTO appVersionWrapperDTO) {
        if (appVersionWrapperDTO == null) {
            return null;
        }
        AppVersionOnlyDTO version = appVersionWrapperDTO.getVersion();
        if (version == null) {
            return null;
        }
        String number = version.getNumber();
        if (number == null) {
            return null;
        }
        return number;
    }
}

