/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.infra.dto;

import com.alibaba.bizworks.infra.dto.Response;
import java.util.Collection;
import java.util.Collections;

public class MultiResponse<T>
extends Response {
    private static final long serialVersionUID = 1L;
    private Data<T> data;

    private MultiResponse() {
        this.data = new Data();
    }

    private MultiResponse(String code, String message) {
        super(code, message);
        this.data = new Data();
    }

    private MultiResponse(Long totalCount, Collection<T> items) {
        this.data = new Data<T>(totalCount, items);
    }

    public Data<T> getData() {
        return this.data;
    }

    public static MultiResponse buildSuccess() {
        MultiResponse response = new MultiResponse();
        return response;
    }

    public static <T> MultiResponse<T> buildSuccess(Long totalCount, Collection<T> items) {
        MultiResponse<T> response = new MultiResponse<T>(totalCount, items);
        return response;
    }

    public static <T> MultiResponse<T> buildSuccess(Integer totalCount, Collection<T> items) {
        MultiResponse<T> response = new MultiResponse<T>(totalCount.longValue(), items);
        return response;
    }

    public static MultiResponse buildFailure(String code, String message) {
        MultiResponse response = new MultiResponse(code, message);
        return response;
    }

    public static class Data<T> {
        private Long totalCount;
        private Collection<T> items;

        public Data() {
            this.totalCount = 0L;
            this.items = Collections.emptyList();
        }

        public Data(Long totalCount, Collection<T> items) {
            this.totalCount = totalCount;
            this.items = items == null ? Collections.emptyList() : items;
        }

        public Long getTotalCount() {
            return this.totalCount;
        }

        public Collection<T> getItems() {
            return this.items;
        }
    }
}

