/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bizworks.infra.dto;

import com.alibaba.bizworks.infra.dto.DTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;

public class Response
extends DTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CODE_PREFIX = "BWE_";
    private static final String CODE_OK = "OK";
    private String code;
    private String message;

    protected Response() {
        this.code = CODE_OK;
        this.message = "";
    }

    protected Response(String code, String message) {
        if (!code.startsWith(CODE_PREFIX)) {
            throw new IllegalArgumentException("illegal error code");
        }
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public boolean isSuccess() {
        return this.code != null && this.code.equals(CODE_OK);
    }

    public String toString() {
        return "Response{code='" + this.code + '\'' + ", message='" + this.message + '\'' + '}';
    }

    public static Response buildSuccess() {
        Response response = new Response();
        return response;
    }

    public static Response buildFailure(String code, String message) {
        Response response = new Response(code, message);
        return response;
    }
}

