const path = require("path");
const { assign, isString, isUndefined, isPlainObject } = require("lodash");
const fse = require("fs-extra");

const dataFilePath = path.join(__dirname, "index.json");

let ID = Date.now();

function generateId() {
    return `${`${Date.now().toString(36)}${Math.floor(Math.random() * 10000 + 1000).toString(36)}${((ID++ % 10000) + 1000).toString(
        36,
    )}`.toLowerCase()}`;
}

module.exports = {
    "/api/getOrderList"(req) {
        const { pageNumber, pageSize, sortName, sortType, condition } = req.body;

        let allList = fse.readJSONSync(dataFilePath, { encoding: "utf-8" });

        if (isPlainObject(condition)) {
            Object.keys(condition).forEach((k) => {
                const v = condition[k];

                if (v || v === 0) {
                    if (isString(v)) {
                        allList = allList.filter((item) => {
                            const fv = item[k];

                            return `${fv}`.indexOf(v) > -1;
                        });
                    } else {
                        allList = allList.filter((item) => {
                            const fv = item[k];

                            return fv == v;
                        });
                    }
                }
            });
        }

        if (sortName) {
            allList = allList.sort((a, b) => {
                const v1 = a[sortName];
                const v2 = b[sortName];

                if (isUndefined(v1)) {
                    return true;
                }

                if (isUndefined(v2)) {
                    return false;
                }

                if (isString(v1)) {
                    return sortType == "asc" ? v1.localeCompare(v2) : v2.localeCompare(v1);
                } else {
                    return sortType == "asc" ? v1 - v2 : v2 - v1;
                }
            });
        }

        const start = (pageNumber - 1) * pageSize;
        const dataList = allList.slice(start, start + pageSize);

        return {
            code: "OK",
            data: {
                totalCount: allList.length,
                items: dataList,
            },
        };
    },
    "/api/getOrder"(req) {
        const dataList = fse.readJSONSync(dataFilePath, { encoding: "utf-8" });
        const { id } = req.body;
        const existEntity = dataList.find((item) => item.id == id);

        return {
            code: "OK",
            data: existEntity,
        };
    },
    "/api/createOrder"(req) {
        const dataList = fse.readJSONSync(dataFilePath, { encoding: "utf-8" });
        const { entity } = req.body;

        entity.id = generateId();

        dataList.push(entity);
        fse.outputFileSync(dataFilePath, JSON.stringify(dataList, null, 4));

        return {
            code: "OK",
        };
    },
    "/api/updateOrder"(req) {
        const dataList = fse.readJSONSync(dataFilePath, { encoding: "utf-8" });
        const { entity } = req.body;
        const { id } = entity;
        const existEntity = dataList.find((item) => item.id == entity.id);

        if (existEntity) {
            assign(existEntity, entity);
        }

        fse.outputFileSync(dataFilePath, JSON.stringify(dataList, null, 4));

        return {
            code: "OK",
        };
    },
    "/api/deleteOrder"(req) {
        const dataList = fse.readJSONSync(dataFilePath, { encoding: "utf-8" });
        const { id } = req.body;

        const existIdx = dataList.findIndex((item) => item.id == id);

        if (existIdx > -1) {
            dataList.splice(existIdx, 1);
        }

        fse.outputFileSync(dataFilePath, JSON.stringify(dataList, null, 4));

        return {
            code: "OK",
        };
    },
};
